/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.PersistenceAvailabilityChanged;
import org.infinispan.notifications.cachelistener.event.PersistenceAvailabilityChangedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.StoreUnavailableException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(testName="persistence.PersistenceManagerAvailabilityTest", groups={"functional"})
public class PersistenceManagerAvailabilityTest
extends SingleCacheManagerTest {
    private Cache<Object, Object> createManagerAndGetCache(int startFailures) {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryStoreConfigurationBuilder)config.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).startFailures(startFailures);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, config);
        return this.cacheManager.getCache();
    }

    @Test(expectedExceptions={StoreUnavailableException.class})
    public void testCacheAvailability() {
        Cache<Object, Object> cache = this.createManagerAndGetCache(0);
        cache.put((Object)1, (Object)1);
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        dims.setAvailable(false);
        PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        this.eventually(() -> !pm.isAvailable());
        try {
            cache.put((Object)1, (Object)2);
        }
        catch (Exception e) {
            AssertJUnit.assertEquals((Object)1, (Object)cache.get((Object)1));
            throw e;
        }
        TestingUtil.killCaches(new Cache[0]);
    }

    @Test(expectedExceptions={CacheException.class})
    public void testUnavailableStoreOnStart() {
        this.createManagerAndGetCache(11);
    }

    public void testStoreReconnect() {
        PersistenceAvailabilityListener pal = new PersistenceAvailabilityListener();
        Cache<Object, Object> cache = this.createManagerAndGetCache(0);
        cache.addListener((Object)pal);
        AssertJUnit.assertEquals((int)0, (int)pal.availableCount.get());
        AssertJUnit.assertEquals((int)0, (int)pal.unavailableCount.get());
        cache.put((Object)1, (Object)1);
        PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        AssertJUnit.assertTrue((boolean)pm.isAvailable());
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        dims.setAvailable(false);
        this.eventually(() -> !pm.isAvailable());
        this.eventuallyEquals(1, () -> pal.unavailableCount.get());
        try {
            cache.put((Object)1, (Object)2);
            AssertJUnit.fail((String)("Expected " + StoreUnavailableException.class.getSimpleName()));
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        dims.setAvailable(true);
        this.eventuallyEquals(1, () -> pal.availableCount.get());
        AssertJUnit.assertTrue((boolean)pm.isAvailable());
        cache.put((Object)1, (Object)3);
        AssertJUnit.assertEquals((Object)3, (Object)cache.get((Object)1));
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return null;
    }

    @Override
    protected void setup() throws Exception {
    }

    @Listener
    public static class PersistenceAvailabilityListener {
        AtomicInteger availableCount = new AtomicInteger();
        AtomicInteger unavailableCount = new AtomicInteger();

        @PersistenceAvailabilityChanged
        public void availabilityChange(PersistenceAvailabilityChangedEvent event) {
            if (event.isAvailable()) {
                this.availableCount.incrementAndGet();
            } else {
                this.unavailableCount.incrementAndGet();
            }
        }
    }
}

