/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.persistence.support.WaitNonBlockingStore;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.PreloadWithAsyncStoreTest")
public class PreloadWithAsyncStoreTest
extends SingleCacheManagerTest {
    private static final Object[] KEYS = new Object[]{"key_1", "key_2", "key_3", "key_4"};
    private static final Object[] VALUES = new Object[]{"value_1", "value_2", "value_3", "value_4"};

    public void testtPreloadWithNonTransactionalCache() throws Exception {
        this.doTest(CacheType.NO_TRANSACTIONAL);
    }

    public void testtPreloadWithTransactionalUsingSynchronizationCache() throws Exception {
        this.doTest(CacheType.TRANSACTIONAL_SYNCHRONIZATION);
    }

    public void testPreloadWithTransactionalUsingXACache() throws Exception {
        this.doTest(CacheType.TRANSACTIONAL_XA);
    }

    public void testPreloadWithTransactionalUsingXAAndRecoveryCache() throws Exception {
        this.doTest(CacheType.TRANSACTIONAL_XA_RECOVERY);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager();
        for (CacheType cacheType : CacheType.values()) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(this.getClass().getName()).async().enable();
            builder.transaction().transactionMode(cacheType.transactionMode).useSynchronization(cacheType.useSynchronization).recovery().enabled(cacheType.useRecovery);
            builder.customInterceptors().addInterceptor().index(0).interceptor((AsyncInterceptor)new ExceptionTrackerInterceptor());
            cm.defineConfiguration(cacheType.cacheName, builder.build());
        }
        return cm;
    }

    protected void doTest(CacheType cacheType) throws Exception {
        int i;
        Cache cache = this.cacheManager.getCache(cacheType.cacheName);
        ExceptionTrackerInterceptor interceptor = this.getInterceptor((Cache<Object, Object>)cache);
        AssertJUnit.assertTrue((String)"Preload should be enabled.", (boolean)cache.getCacheConfiguration().persistence().preload());
        AssertJUnit.assertTrue((String)"Async Store should be enabled.", (boolean)cache.getCacheConfiguration().persistence().usingAsyncStore());
        WaitDelegatingNonBlockingStore<Object, Object> store = TestingUtil.getFirstStoreWait(cache);
        this.assertNotInCacheAndStore((Cache<Object, Object>)cache, store, KEYS);
        for (i = 0; i < KEYS.length; ++i) {
            cache.put(KEYS[i], VALUES[i]);
        }
        for (i = 1; i < KEYS.length; ++i) {
            this.assertInCacheAndStore((Cache<Object, Object>)cache, store, KEYS[i], VALUES[i]);
        }
        DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((String)"Wrong number of keys in data container after puts.", (int)KEYS.length, (int)dataContainer.size());
        AssertJUnit.assertEquals((String)"Some exceptions has been caught during the puts.", (int)0, (int)interceptor.exceptionsCaught.get());
        cache.stop();
        AssertJUnit.assertEquals((String)"Expected empty data container after stop.", (int)0, (int)dataContainer.size());
        AssertJUnit.assertEquals((String)"Some exceptions has been caught during the stop.", (int)0, (int)interceptor.exceptionsCaught.get());
        cache.start();
        AssertJUnit.assertTrue((String)"Preload should be enabled after restart.", (boolean)cache.getCacheConfiguration().persistence().preload());
        AssertJUnit.assertTrue((String)"Async Store should be enabled after restart.", (boolean)cache.getCacheConfiguration().persistence().usingAsyncStore());
        dataContainer = cache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((String)"Wrong number of keys in data container after preload.", (int)KEYS.length, (int)dataContainer.size());
        AssertJUnit.assertEquals((String)"Some exceptions has been caught during the preload.", (int)0, (int)interceptor.exceptionsCaught.get());
        store = TestingUtil.getStoreWait(cache, 0, false);
        for (int i2 = 1; i2 < KEYS.length; ++i2) {
            this.assertInCacheAndStore((Cache<Object, Object>)cache, store, KEYS[i2], VALUES[i2]);
        }
    }

    private void assertInCacheAndStore(Cache<Object, Object> cache, WaitNonBlockingStore<Object, Object> loader, Object key, Object value) throws PersistenceException {
        InternalCacheValue se = cache.getAdvancedCache().getDataContainer().get(key).toInternalCacheValue();
        this.assertStoredEntry(se.getValue(), value, "Cache", key);
        MarshallableEntry<Object, Object> me = loader.loadEntry(key);
        this.assertStoredEntry(me.getValue(), value, "Store", key);
    }

    private void assertStoredEntry(Object value, Object expectedValue, String src, Object key) {
        AssertJUnit.assertNotNull((String)(src + " entry for key " + key + " should NOT be null"), (Object)value);
        AssertJUnit.assertEquals((String)(src + " should contain value " + expectedValue + " under key " + key + " but was " + value), (Object)expectedValue, (Object)value);
    }

    private <T> void assertNotInCacheAndStore(Cache<Object, Object> cache, WaitNonBlockingStore<Object, Object> store, T ... keys) throws PersistenceException {
        for (T key : keys) {
            AssertJUnit.assertFalse((String)("Cache should not contain key " + key), (boolean)cache.getAdvancedCache().getDataContainer().containsKey(key));
            AssertJUnit.assertFalse((String)("Store should not contain key " + key), (boolean)store.contains(key));
        }
    }

    private ExceptionTrackerInterceptor getInterceptor(Cache<Object, Object> cache) {
        return (ExceptionTrackerInterceptor)cache.getAdvancedCache().getAsyncInterceptorChain().findInterceptorWithClass(ExceptionTrackerInterceptor.class);
    }

    static class ExceptionTrackerInterceptor
    extends BaseAsyncInterceptor {
        private AtomicInteger exceptionsCaught = new AtomicInteger();

        ExceptionTrackerInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            return this.invokeNextAndExceptionally(ctx, command, (rCtx, rCommand, throwable) -> {
                this.exceptionsCaught.incrementAndGet();
                throw throwable;
            });
        }
    }

    private static enum CacheType {
        NO_TRANSACTIONAL("NO_TX"),
        TRANSACTIONAL_SYNCHRONIZATION(TransactionMode.TRANSACTIONAL, "TX_SYNC", true, false),
        TRANSACTIONAL_XA(TransactionMode.TRANSACTIONAL, "TX_XA", false, false),
        TRANSACTIONAL_XA_RECOVERY(TransactionMode.TRANSACTIONAL, "TX_XA_RECOVERY", false, true);

        final TransactionMode transactionMode;
        final String cacheName;
        final boolean useSynchronization;
        final boolean useRecovery;

        private CacheType(TransactionMode transactionMode, String cacheName, boolean useSynchronization, boolean useRecovery) {
            this.transactionMode = transactionMode;
            this.cacheName = cacheName;
            this.useSynchronization = useSynchronization;
            this.useRecovery = useRecovery;
        }

        private CacheType(String cacheName) {
            this(TransactionMode.NON_TRANSACTIONAL, cacheName, false, false);
        }
    }
}

