/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.SharedStoreTest", groups={"functional"})
@CleanupAfterMethod
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC, CacheMode.SCATTERED_SYNC})
public class SharedStoreTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(SharedStoreTest.class.getName()).purgeOnStartup(false)).shared(true)).clustering().cacheMode(this.cacheMode).build();
        this.createCluster(cfg, 3);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        List<DummyInMemoryStore> cachestores = TestingUtil.cachestores(this.caches());
        super.clearContent();
        this.clearStoreStats(cachestores);
    }

    private void clearStoreStats(List<DummyInMemoryStore> cachestores) {
        cachestores.forEach(DummyInMemoryStore::clearStats);
    }

    public void testUnnecessaryWrites() throws PersistenceException {
        this.cache(0).put((Object)"key", (Object)"value");
        for (Cache c : this.caches()) {
            AssertJUnit.assertEquals((Object)"value", (Object)c.get((Object)"key"));
        }
        List<DummyInMemoryStore> cacheStores = TestingUtil.cachestores(this.caches());
        for (DummyInMemoryStore dummyInMemoryStore : cacheStores) {
            AssertJUnit.assertTrue((boolean)dummyInMemoryStore.contains("key"));
            AssertJUnit.assertEquals((int)0, (int)dummyInMemoryStore.stats().get("clear"));
            AssertJUnit.assertEquals((int)0, (int)dummyInMemoryStore.stats().get("clear"));
            AssertJUnit.assertEquals((int)1, (int)dummyInMemoryStore.stats().get("write"));
        }
        this.cache(0).remove((Object)"key");
        for (Cache cache : this.caches()) {
            AssertJUnit.assertNull((Object)cache.get((Object)"key"));
        }
        for (DummyInMemoryStore dummyInMemoryStore : cacheStores) {
            if (this.cacheMode.isScattered()) {
                MarshallableEntry entry = dummyInMemoryStore.loadEntry("key");
                assert (entry == null || entry.getValue() == null);
                AssertJUnit.assertEquals((String)"Entry should have been replaced by tombstone", (Object)2, (Object)dummyInMemoryStore.stats().get("write"));
                continue;
            }
            assert (!dummyInMemoryStore.contains("key"));
            AssertJUnit.assertEquals((String)"Entry should have been removed from the cache store just once", (Object)1, (Object)dummyInMemoryStore.stats().get("delete"));
        }
    }

    public void testSkipSharedCacheStoreFlagUsage() throws PersistenceException {
        this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_SHARED_CACHE_STORE).put((Object)"key", (Object)"value");
        assert (this.cache(0).get((Object)"key").equals("value"));
        List<DummyInMemoryStore> cacheStores = TestingUtil.cachestores(this.caches());
        for (DummyInMemoryStore dimcs : cacheStores) {
            assert (!dimcs.contains("key"));
            assert (dimcs.stats().get("write") == 0) : "Cache store should NOT contain any entry. Put was with SKIP_SHARED_CACHE_STORE flag.";
        }
    }

    public void testSize() {
        List caches = this.caches();
        Cache cache0 = caches.get(0);
        cache0.put((Object)"key", (Object)"value");
        this.clearStoreStats(TestingUtil.cachestores(this.caches()));
        AssertJUnit.assertEquals((int)1, (int)cache0.size());
        this.assertStoreDistinctInvocationAmount(cache0, 1);
        this.assertStoreStatInvocationEquals(cache0, "size", 1);
    }

    private void assertStoreStatInvocationEquals(Cache<?, ?> cache, String invocationName, int invocationCount) {
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        AssertJUnit.assertEquals((int)invocationCount, (int)dims.stats().get(invocationName));
    }

    private void assertStoreDistinctInvocationAmount(Cache<?, ?> cache, int distinctInvocations) {
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        AssertJUnit.assertEquals((long)distinctInvocations, (long)dims.stats().values().stream().filter(i -> i > 0).count());
    }
}

