/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.IsolationLevel;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="persistence.UnnecessaryLoadingTest", groups={"functional"}, singleThreaded=true)
@CleanupAfterMethod
public class UnnecessaryLoadingTest
extends SingleCacheManagerTest {
    DummyInMemoryStore store;
    private PersistenceManagerImpl persistenceManager;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        ((DummyInMemoryStoreConfigurationBuilder)((CountingStoreConfigurationBuilder)cfg.invocationBatching().enable().persistence().addStore(CountingStoreConfigurationBuilder.class)).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        return TestCacheManagerFactory.createCacheManager(cfg);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.persistenceManager = (PersistenceManagerImpl)TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        this.store = (DummyInMemoryStore)TestingUtil.getStore(this.cache, 1, false);
    }

    public void testRepeatedLoads() throws PersistenceException {
        CountingStore countingCS = this.getCountingCacheStore();
        this.store.write(MarshalledEntryUtil.create("k1", "v1", this.cache));
        assert (countingCS.numLoads == 0);
        assert (countingCS.numContains == 0);
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
    }

    public void testSkipCacheFlagUsage() throws PersistenceException {
        CountingStore countingCS = this.getCountingCacheStore();
        this.store.write(MarshalledEntryUtil.create("k1", "v1", this.cache));
        assert (countingCS.numLoads == 0);
        assert (countingCS.numContains == 0);
        assert (this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)"k1") == null);
        assert (countingCS.numLoads == 0);
        assert (countingCS.numContains == 0);
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        this.store.write(MarshalledEntryUtil.create("k2", "v2", this.cache));
        Object putReturn = this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).put((Object)"k2", (Object)"v2-second");
        assert (putReturn == null);
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert ("v2-second".equals(this.cache.get((Object)"k2")));
        putReturn = this.cache.put((Object)"k2", (Object)"v2-second");
        assert ("v2-second".equals(putReturn));
        InvocationContextFactory icf = TestingUtil.extractComponent(this.cache, InvocationContextFactory.class);
        InvocationContext context = icf.createSingleKeyNonTxInvocationContext();
        assert ("v2-second".equals(((MarshallableEntry)CompletionStages.join((CompletionStage)this.persistenceManager.loadFromAllStores((Object)"k2", context.isOriginLocal(), true))).getValue()));
        Assert.assertEquals((int)countingCS.numLoads, (int)2, (String)("Expected 2, was " + countingCS.numLoads));
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        this.cache.containsKey((Object)"k1");
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert (!this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).containsKey((Object)"k3"));
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert (countingCS.numLoads == 2) : "Expected 2, was " + countingCS.numLoads;
        boolean batchStarted = this.cache.getAdvancedCache().startBatch();
        assert (batchStarted);
        assert (null == this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)"k1batch"));
        assert (countingCS.numLoads == 2) : "Expected 2, was " + countingCS.numLoads;
        assert (null == this.cache.getAdvancedCache().get((Object)"k2batch"));
        assert (countingCS.numLoads == 3) : "Expected 3, was " + countingCS.numLoads;
        this.cache.endBatch(true);
    }

    private CountingStore getCountingCacheStore() {
        CountingStore countingCS = (CountingStore)TestingUtil.getFirstLoader(this.cache);
        this.reset(this.cache, countingCS);
        return countingCS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipCacheLoadFlagUsage() throws PersistenceException {
        CountingStore countingCS = this.getCountingCacheStore();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        try {
            this.store.write(MarshalledEntryUtil.create("home", "Vermezzo", (Marshaller)sm));
            this.store.write(MarshalledEntryUtil.create("home-second", "Newcastle Upon Tyne", (Marshaller)sm));
            assert (countingCS.numLoads == 0);
            assert (this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)"home") == null);
            assert (countingCS.numLoads == 0);
            assert (this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).put((Object)"home", (Object)"Newcastle") == null);
            assert (countingCS.numLoads == 0);
            Object put = this.cache.getAdvancedCache().put((Object)"home-second", (Object)"Newcastle Upon Tyne, second");
            Assert.assertEquals((Object)put, (Object)"Newcastle Upon Tyne");
            assert (countingCS.numLoads == 1);
        }
        finally {
            sm.stop();
        }
    }

    private void reset(Cache<?, ?> cache, CountingStore countingCS) {
        cache.clear();
        countingCS.numLoads = 0;
        countingCS.numContains = 0;
    }

    public static class CountingStoreConfigurationBuilder
    extends AbstractStoreConfigurationBuilder<CountingStoreConfiguration, CountingStoreConfigurationBuilder> {
        public CountingStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
            super(builder, CountingStoreConfiguration.attributeDefinitionSet());
        }

        public CountingStoreConfiguration create() {
            return new CountingStoreConfiguration(this.attributes.protect(), this.async.create());
        }

        public CountingStoreConfigurationBuilder self() {
            return this;
        }
    }

    @BuiltBy(value=CountingStoreConfigurationBuilder.class)
    @ConfigurationFor(value=CountingStore.class)
    public static class CountingStoreConfiguration
    extends AbstractStoreConfiguration {
        public CountingStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
            super(attributes, async);
        }
    }

    public static class CountingStore
    implements SegmentedAdvancedLoadWriteStore {
        public int numLoads;
        public int numContains;

        public int size() {
            return 0;
        }

        public void clear() {
        }

        public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
        }

        public void init(InitializationContext ctx) {
        }

        public void write(MarshallableEntry entry) {
        }

        public boolean delete(Object key) {
            return false;
        }

        public MarshallableEntry loadEntry(Object key) throws PersistenceException {
            this.incrementLoads();
            return null;
        }

        public Publisher<MarshallableEntry> entryPublisher(Predicate filter, boolean fetchValue, boolean fetchMetadata) {
            return null;
        }

        public MarshallableEntry get(int segment, Object key) {
            return this.loadEntry(key);
        }

        public boolean contains(int segment, Object key) {
            return this.contains(key);
        }

        public void write(int segment, MarshallableEntry entry) {
        }

        public boolean delete(int segment, Object key) {
            return false;
        }

        public Publisher<MarshallableEntry> entryPublisher(IntSet segments, Predicate filter, boolean fetchValue, boolean fetchMetadata) {
            return null;
        }

        public void start() {
        }

        public void stop() {
        }

        public boolean contains(Object key) throws PersistenceException {
            ++this.numContains;
            return false;
        }

        private void incrementLoads() {
            ++this.numLoads;
        }

        public int size(IntSet segments) {
            return 0;
        }

        public Publisher publishKeys(IntSet segments, Predicate filter) {
            return null;
        }

        public void clear(IntSet segments) {
        }
    }
}

