/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.dummy;

import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfiguration;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.WaitNonBlockingStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@ConfiguredBy(value=DummyInMemoryStoreConfiguration.class)
@Store(shared=true)
public class DummyInMemoryStore
implements WaitNonBlockingStore {
    public static final int SLOW_STORE_WAIT = 100;
    private static final Log log = LogFactory.getLog(DummyInMemoryStore.class);
    private static final ConcurrentMap<String, AtomicReferenceArray<Map<Object, byte[]>>> stores = new ConcurrentHashMap<String, AtomicReferenceArray<Map<Object, byte[]>>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, AtomicInteger>> storeStats = new ConcurrentHashMap<String, ConcurrentMap<String, AtomicInteger>>();
    private String storeName;
    private AtomicReferenceArray<Map<Object, byte[]>> store;
    private ConcurrentMap<String, AtomicInteger> stats;
    private int segmentCount;
    private AtomicInteger initCount = new AtomicInteger();
    private TimeService timeService;
    private Cache<?, ?> cache;
    private PersistenceMarshaller marshaller;
    private DummyInMemoryStoreConfiguration configuration;
    private KeyPartitioner keyPartitioner;
    private InitializationContext ctx;
    private volatile boolean running;
    private volatile boolean available;
    private AtomicInteger startAttempts = new AtomicInteger();

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (DummyInMemoryStoreConfiguration)ctx.getConfiguration();
        this.keyPartitioner = ctx.getKeyPartitioner();
        this.cache = ctx.getCache();
        this.marshaller = ctx.getPersistenceMarshaller();
        this.storeName = this.makeStoreName(this.configuration, this.cache);
        this.initCount.incrementAndGet();
        this.timeService = ctx.getTimeService();
        if (this.store != null) {
            return CompletableFutures.completedNull();
        }
        if (this.configuration.startFailures() > this.startAttempts.incrementAndGet()) {
            throw new PersistenceException();
        }
        if (this.configuration.segmented()) {
            ClusteringConfiguration clusteringConfiguration = this.cache.getCacheConfiguration().clustering();
            this.segmentCount = clusteringConfiguration.hash().numSegments();
        } else {
            this.segmentCount = 1;
        }
        this.store = new AtomicReferenceArray(this.segmentCount);
        this.stats = this.newStatsMap();
        boolean shouldStartSegments = true;
        if (this.storeName != null) {
            AtomicReferenceArray<Map<Object, byte[]>> existing = stores.putIfAbsent(this.storeName, this.store);
            if (existing != null) {
                this.store = existing;
                log.debugf("Reusing in-memory cache store %s", (Object)this.storeName);
                shouldStartSegments = false;
            } else {
                TestResourceTracker.addResource((TestResourceTracker.Cleaner)new TestResourceTracker.Cleaner<String>(this.storeName){

                    public void close() {
                        DummyInMemoryStore.removeStoreData((String)this.ref);
                        storeStats.remove(this.ref);
                    }
                });
                log.debugf("Creating new in-memory cache store %s", (Object)this.storeName);
            }
            ConcurrentMap<String, AtomicInteger> existingStats = storeStats.putIfAbsent(this.storeName, this.stats);
            if (existingStats != null) {
                this.stats = existingStats;
            }
        }
        if (shouldStartSegments) {
            for (int i = 0; i < this.segmentCount; ++i) {
                this.store.set(i, new ConcurrentHashMap());
            }
        }
        this.record("start");
        this.running = true;
        this.available = true;
        return CompletableFutures.completedNull();
    }

    @Override
    public KeyPartitioner getKeyPartitioner() {
        return this.keyPartitioner;
    }

    private String makeStoreName(DummyInMemoryStoreConfiguration configuration, Cache<?, ?> cache) {
        String configName = configuration.storeName();
        if (configName == null) {
            return null;
        }
        return cache != null ? configName + "_" + cache.getName() : configName;
    }

    public DummyInMemoryStore(String storeName) {
        this.storeName = storeName;
    }

    public DummyInMemoryStore() {
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getInitCount() {
        return this.initCount.get();
    }

    private void record(String method) {
        ((AtomicInteger)this.stats.get(method)).incrementAndGet();
    }

    private Map<Object, byte[]> mapForSegment(int segment) {
        if (!this.configuration.segmented()) {
            return this.store.get(0);
        }
        Map<Object, byte[]> map = this.store.get(segment);
        return map == null ? Collections.emptyMap() : map;
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.SHAREABLE, NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry entry) {
        this.assertRunning();
        this.record("write");
        if (this.configuration.slow()) {
            TestingUtil.sleepThread(100L);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Store %s for segment %s in dummy map store@%s", (Object)entry, (Object)segment, (Object)Util.hexIdHashCode(this.store));
        }
        Map<Object, byte[]> map = this.mapForSegment(segment);
        map.put(entry.getKey(), this.serialize(entry));
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> clear() {
        this.assertRunning();
        this.record("clear");
        if (log.isTraceEnabled()) {
            log.trace((Object)"Clear store");
        }
        for (int i = 0; i < this.store.length(); ++i) {
            Map<Object, byte[]> map = this.store.get(i);
            if (map == null) continue;
            map.clear();
        }
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        this.assertRunning();
        this.record("delete");
        Map<Object, byte[]> map = this.mapForSegment(segment);
        if (map.remove(key) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Removed %s from dummy store for segment %s", key, (Object)segment);
            }
            return CompletableFutures.completedTrue();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Key %s not present in store, so don't remove", key);
        }
        return CompletableFutures.completedFalse();
    }

    public Publisher<MarshallableEntry> purgeExpired() {
        this.assertRunning();
        this.record("purgeExpired");
        return Flowable.defer(() -> {
            long currentTimeMillis = this.timeService.wallClockTime();
            return Flowable.range((int)0, (int)this.store.length()).concatMap(offset -> {
                Map<Object, byte[]> map = this.store.get((int)offset);
                if (map == null) {
                    return Flowable.empty();
                }
                return Flowable.fromIterable(map.entrySet()).map(entry -> this.deserialize(entry.getKey(), (byte[])entry.getValue())).filter(me -> this.isExpired((MarshallableEntry)me, currentTimeMillis)).doOnNext(me -> map.remove(me.getKey()));
            });
        });
    }

    public CompletionStage<MarshallableEntry> load(int segment, Object key) {
        this.assertRunning();
        this.record("load");
        if (key == null) {
            return null;
        }
        Map<Object, byte[]> map = this.mapForSegment(segment);
        MarshallableEntry me = this.deserialize(key, map.get(key));
        if (me == null) {
            return CompletableFutures.completedNull();
        }
        long now = this.timeService.wallClockTime();
        if (this.isExpired(me, now)) {
            log.tracef("Key %s exists, but has expired.  Entry is %s", key, (Object)me);
            return CompletableFutures.completedNull();
        }
        return CompletableFuture.completedFuture(me);
    }

    private boolean isExpired(MarshallableEntry me, long now) {
        return me.isExpired(now);
    }

    public Flowable<MarshallableEntry> publishEntries(IntSet segments, Predicate filter, boolean fetchValue) {
        this.assertRunning();
        this.record("publishEntries");
        log.tracef("Publishing entries in store %s segments %s with filter %s", (Object)this.storeName, (Object)segments, (Object)filter);
        Flowable flowable = this.configuration.segmented() ? Flowable.fromIterable((Iterable)segments).concatMap(segment -> {
            Map<Object, byte[]> map = this.store.get((int)segment);
            if (map == null) {
                return Flowable.empty();
            }
            return Flowable.fromIterable(map.entrySet());
        }) : Flowable.fromIterable(this.store.get(0).entrySet());
        if (filter != null) {
            flowable = flowable.filter(e -> filter.test(e.getKey()));
        }
        if (this.configuration.slow()) {
            flowable = flowable.doOnNext(ignore -> Thread.sleep(100L));
        }
        Flowable meFlowable = flowable.map(entry -> this.deserialize(entry.getKey(), (byte[])entry.getValue()));
        return Flowable.defer(() -> {
            long currentTimeMillis = this.timeService.wallClockTime();
            return meFlowable.filter(me -> !this.isExpired((MarshallableEntry)me, currentTimeMillis));
        });
    }

    private ConcurrentMap<String, AtomicInteger> newStatsMap() {
        ConcurrentHashMap<String, AtomicInteger> m = new ConcurrentHashMap<String, AtomicInteger>();
        for (Method method : NonBlockingStore.class.getMethods()) {
            m.put(method.getName(), new AtomicInteger(0));
        }
        return m;
    }

    public CompletionStage<Void> stop() {
        if (this.running) {
            this.record("stop");
            this.running = false;
            this.available = false;
            this.store = null;
        }
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Boolean> isAvailable() {
        return CompletableFutures.booleanStage((boolean)this.available);
    }

    public void setAvailable(boolean available) {
        log.debugf("Store availability change: %s -> %s", (Object)this.available, (Object)available);
        this.available = available;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public static long getStoreDataSize(String storeName) {
        AtomicReferenceArray store = (AtomicReferenceArray)stores.get(storeName);
        return store != null ? (Long)CompletionStages.join(DummyInMemoryStore.size(IntSets.immutableRangeSet((int)store.length()), store)) : 0L;
    }

    public static void removeStoreData(String storeName) {
        stores.remove(storeName);
    }

    public static void removeStatData(String storeName) {
        storeStats.remove(storeName);
    }

    public static AtomicReferenceArray<Map<Object, byte[]>> getStoreDataForName(String storeName) {
        return (AtomicReferenceArray)stores.get(storeName);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.store.length(); ++i) {
            Map<Object, byte[]> map = this.store.get(i);
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set<Object> keySet() {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < this.store.length(); ++i) {
            Map<Object, byte[]> map = this.store.get(i);
            if (map == null) continue;
            set.addAll(map.keySet());
        }
        return set;
    }

    public Map<String, Integer> stats() {
        HashMap<String, Integer> copy = new HashMap<String, Integer>(this.stats.size());
        for (String k : this.stats.keySet()) {
            copy.put(k, ((AtomicInteger)this.stats.get(k)).get());
        }
        return copy;
    }

    public void clearStats() {
        for (AtomicInteger atomicInteger : this.stats.values()) {
            atomicInteger.set(0);
        }
    }

    public CompletionStage<Long> size(IntSet segments) {
        this.record("size");
        return DummyInMemoryStore.size(segments, this.store);
    }

    public long size() {
        return (Long)CompletionStages.join(this.size(IntSets.immutableRangeSet((int)this.store.length())));
    }

    private static CompletionStage<Long> size(IntSet segments, AtomicReferenceArray<Map<Object, byte[]>> store) {
        long size = 0L;
        PrimitiveIterator.OfInt iter = segments.iterator();
        while (iter.hasNext()) {
            int segment = iter.nextInt();
            Map<Object, byte[]> map = store.get(segment);
            if (map == null) continue;
            size += (long)map.size();
        }
        return CompletableFuture.completedFuture(size);
    }

    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        this.assertRunning();
        this.record("containsKey");
        if (key == null) {
            return CompletableFutures.completedFalse();
        }
        Map<Object, byte[]> map = this.mapForSegment(segment);
        MarshallableEntry me = this.deserialize(key, map.get(key));
        if (me == null) {
            return CompletableFutures.completedFalse();
        }
        long now = this.timeService.wallClockTime();
        if (this.isExpired(me, now)) {
            log.tracef("Key %s exists, but has expired.  Entry is %s", key, (Object)me);
            return CompletableFutures.completedFalse();
        }
        return CompletableFutures.completedTrue();
    }

    private byte[] serialize(MarshallableEntry entry) {
        try {
            return this.marshaller.objectToByteBuffer((Object)entry.getMarshalledValue());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
    }

    private MarshallableEntry deserialize(Object key, byte[] b) {
        try {
            if (b == null) {
                return null;
            }
            MarshalledValue value = (MarshalledValue)this.marshaller.objectFromByteBuffer(b);
            return this.ctx.getMarshallableEntryFactory().create(key, value);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void assertRunning() {
        if (!this.running) {
            throw new IllegalLifecycleStateException();
        }
        if (!this.available) {
            throw new PersistenceException();
        }
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        this.assertRunning();
        this.record("addSegments");
        if (this.configuration.segmented() && this.storeName == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Adding segments %s", (Object)segments);
            }
            segments.forEach(segment -> {
                if (this.store.get(segment) == null) {
                    this.store.set(segment, new ConcurrentHashMap());
                }
            });
        }
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        this.assertRunning();
        this.record("removeSegments");
        if (this.configuration.segmented() && this.storeName == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Removing segments %s", (Object)segments);
            }
            segments.forEach(segment -> this.store.getAndSet(segment, null));
        }
        return CompletableFutures.completedNull();
    }

    public DummyInMemoryStoreConfiguration getConfiguration() {
        return this.configuration;
    }
}

