/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.file.SingleFileMigrateCorruptTest")
public class SingleFileMigrateCorruptTest
extends AbstractInfinispanTest {
    static final String CACHE_NAME = "update-cache";
    private String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() throws IOException {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        new File(this.tmpDirectory).mkdirs();
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public void testAllEntriesRecovered() throws Exception {
        Cache cache;
        InputStream is = FileLookupFactory.newInstance().lookupFile("sfs/corrupt/migrate_corrupt_test.dat", Thread.currentThread().getContextClassLoader());
        Files.copy(is, Paths.get(this.tmpDirectory, new String[0]).resolve("update-cache.dat"), StandardCopyOption.REPLACE_EXISTING);
        ConfigurationBuilderHolder cbh = new ConfigurationBuilderHolder();
        ((SingleFileStoreConfigurationBuilder)cbh.newConfigurationBuilder(CACHE_NAME).persistence().addSingleFileStore().segmented(false)).location(this.tmpDirectory);
        try (DefaultCacheManager cacheManager = new DefaultCacheManager(cbh, true);){
            cache = cacheManager.getCache(CACHE_NAME);
            this.assertContent((AdvancedCache<Object, Object>)cache.getAdvancedCache(), false);
            cache.put((Object)0, (Object)"RuntimeValue");
            cache.put((Object)"NewKey", (Object)"NewValue");
        }
        cacheManager = new DefaultCacheManager(cbh, true);
        try {
            cache = cacheManager.getCache(CACHE_NAME);
            this.assertContent((AdvancedCache<Object, Object>)cache.getAdvancedCache(), true);
            AssertJUnit.assertEquals((Object)"RuntimeValue", (Object)cache.get((Object)0));
            AssertJUnit.assertEquals((Object)"NewValue", (Object)cache.get((Object)"NewKey"));
        }
        finally {
            cacheManager.close();
        }
    }

    private void assertContent(AdvancedCache<Object, Object> cache, boolean skip0) {
        IntStream.range(skip0 ? 1 : 0, 1000).forEach(i -> {
            if (i % 4 == 0) {
                AssertJUnit.assertEquals((Object)(i + "-updated-12.1"), (Object)cache.get((Object)i));
            } else {
                AssertJUnit.assertEquals((Object)i, (Object)cache.get((Object)i));
            }
        });
        IntStream.range(1000, 2000).forEach(i -> {
            CacheEntry entry = cache.getCacheEntry((Object)i);
            if (i % 8 == 0) {
                AssertJUnit.assertNotNull((String)("No entry found for key: " + i), (Object)entry);
                AssertJUnit.assertEquals((Object)(i + "-updated-12.1"), (Object)entry.getValue());
                AssertJUnit.assertEquals((long)-1L, (long)entry.getLifespan());
            } else if (i % 4 == 0) {
                AssertJUnit.assertNull((String)("Entry was supposed to be expired for key: " + i), (Object)entry);
            } else {
                AssertJUnit.assertNotNull((String)("No entry found for key: " + i), (Object)entry);
                AssertJUnit.assertEquals((Object)i, (Object)entry.getValue());
                AssertJUnit.assertEquals((long)SingleFileMigrateCorruptTest.longTimeMilliseconds(), (long)entry.getLifespan());
            }
        });
        IntStream.range(2000, 3000).forEach(i -> {
            if (i % 4 == 0) {
                AssertJUnit.assertEquals((Object)(i + "-12.1-with-expiration"), (Object)cache.get((Object)i));
            } else if (i % 2 == 0) {
                AssertJUnit.assertNull((Object)cache.get((Object)i));
            } else {
                AssertJUnit.assertEquals((Object)(i + "-12.1"), (Object)cache.get((Object)i));
            }
        });
    }

    static long longTimeMilliseconds() {
        return TimeUnit.DAYS.toMillis(18250L);
    }
}

