/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.BaseNonBlockingStoreTest;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.SingleFile.SingleFileStoreTest")
public class SingleFileStoreTest
extends BaseNonBlockingStoreTest {
    private String tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    private boolean segmented;

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public SingleFileStoreTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new SingleFileStoreTest().segmented(false), new SingleFileStoreTest().segmented(true)};
    }

    @Override
    protected String parameters() {
        return "[" + this.segmented + "]";
    }

    @Override
    protected Configuration buildConfig(ConfigurationBuilder cb) {
        cb.clustering().hash().numSegments(16);
        this.createCacheStoreConfig(cb.persistence());
        return cb.build();
    }

    protected SingleFileStoreConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        SingleFileStoreConfigurationBuilder cfg = (SingleFileStoreConfigurationBuilder)lcb.addStore(SingleFileStoreConfigurationBuilder.class);
        cfg.segmented(this.segmented);
        cfg.location(this.tmpDirectory);
        cfg.fragmentationFactor(0.5f);
        return cfg;
    }

    protected NonBlockingStore createStore() {
        this.clearTempDir();
        return new SingleFileStore();
    }

    public void testSegmentsRemovedAndAdded() {
        String key = "first-key";
        String value = "some-value";
        int segment = this.keyPartitioner.getSegment((Object)key);
        if (!this.segmented) {
            Exceptions.expectException(UnsupportedOperationException.class, () -> this.store.removeSegments(IntSets.immutableSet((int)segment)));
            Exceptions.expectException(UnsupportedOperationException.class, () -> this.store.addSegments(IntSets.immutableSet((int)segment)));
            return;
        }
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create(key, value);
        MarshallableEntry me = MarshalledEntryUtil.create(entry, (Marshaller)this.getMarshaller());
        this.store.write(me);
        Assert.assertTrue((boolean)this.store.contains(key));
        CompletionStages.join(this.store.removeSegments(IntSets.immutableSet((int)segment)));
        Assert.assertFalse((boolean)this.store.contains(key));
        CompletionStages.join(this.store.addSegments(IntSets.immutableSet((int)segment)));
        this.store.write(me);
        Assert.assertTrue((boolean)this.store.contains(key));
    }

    public void testStopDuringClear() {
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create("key", "value");
        MarshallableEntry me = MarshalledEntryUtil.create(entry, (Marshaller)this.getMarshaller());
        this.store.write(me);
        CompletionStage<Void> clearStage = this.store.clear();
        this.store.stopAndWait();
        CompletionStages.join(clearStage);
        this.startStore(this.store);
        long size = (Long)CompletionStages.join(this.store.size(IntSets.immutableRangeSet((int)this.segmentCount)));
        Assert.assertTrue((size == 0L || size == 1L ? 1 : 0) != 0);
    }
}

