/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.persistence.AbstractPersistenceCompatibilityTest;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.test.data.Value;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreCompatibilityTest")
public class SoftIndexFileStoreCompatibilityTest
extends AbstractPersistenceCompatibilityTest<Value> {
    private static final Map<AbstractPersistenceCompatibilityTest.Version, VersionMeta> data = new HashMap<AbstractPersistenceCompatibilityTest.Version, VersionMeta>(2);

    public SoftIndexFileStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    @Override
    protected void amendGlobalConfigurationBuilder(GlobalConfigurationBuilder builder) {
        super.amendGlobalConfigurationBuilder(builder);
        builder.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory());
    }

    @Override
    protected void beforeStartCache() throws Exception {
        Path dataLocation = this.getStoreLocation(this.combinePath(this.tmpDirectory, "data"), "data");
        Path indexLocation = this.getStoreLocation(this.combinePath(this.tmpDirectory, "index"), "index");
        dataLocation.toFile().mkdirs();
        indexLocation.toFile().mkdirs();
        data.get((Object)this.oldVersion).copyFiles(dataLocation, indexLocation);
    }

    @Override
    protected String cacheName() {
        return "sifs-store-cache";
    }

    @Override
    protected void configurePersistence(ConfigurationBuilder builder, boolean generatingData) {
        ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)builder.persistence().addStore(SoftIndexFileStoreConfigurationBuilder.class)).segmented(this.newSegmented)).dataLocation(this.combinePath(this.tmpDirectory, "data")).indexLocation(this.combinePath(this.tmpDirectory, "index"));
    }

    @DataProvider
    public Object[][] segmented() {
        return new Object[][]{{false, true}, {true, true}};
    }

    @Test(dataProvider="segmented")
    public void testReadWriteFrom101(boolean oldSegmented, boolean newSegmented) throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._10_1, oldSegmented, newSegmented);
        this.beforeStartCache();
        this.cacheManager.defineConfiguration(this.cacheName(), this.cacheConfiguration(false).build());
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, (String)".*ISPN000616.*", () -> this.cacheManager.getCache(this.cacheName()));
    }

    @Test(dataProvider="segmented")
    public void testReadWriteFrom11(boolean oldSegmented, boolean newSegmented) throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._11_0, oldSegmented, newSegmented);
        this.doTestReadWrite();
    }

    static {
        data.put(AbstractPersistenceCompatibilityTest.Version._10_1, new VersionMeta("sifs/10_1_x_sifs_data", ""));
        data.put(AbstractPersistenceCompatibilityTest.Version._11_0, new VersionMeta("sifs/11_0_x_sifs_data", "ispn."));
    }

    static class VersionMeta {
        final String root;
        final String prefix;

        VersionMeta(String root, String prefix) {
            this.root = root;
            this.prefix = prefix;
        }

        void copyFiles(Path dataLocation, Path indexLocation) throws IOException {
            String dataPath = String.format("%s/data/%s", this.root, this.prefix + 0);
            SoftIndexFileStoreCompatibilityTest.copyFile(dataPath, dataLocation, this.prefix + 0);
            for (int i = 0; i < 3; ++i) {
                String indexFile = "index." + i;
                String indexPath = String.format("%s/index/%s", this.root, indexFile);
                SoftIndexFileStoreCompatibilityTest.copyFile(indexPath, indexLocation, indexFile);
            }
        }
    }
}

