/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.LOCAL})
@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreRestartTest")
public class SoftIndexFileStoreRestartTest
extends BaseDistStoreTest<Integer, String, SoftIndexFileStoreRestartTest> {
    protected String tmpDirectory;

    public SoftIndexFileStoreRestartTest() {
        this.INIT_CLUSTER_SIZE = 1;
        this.l1CacheEnabled = false;
        this.segmented = true;
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        super.createBeforeClass();
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Override
    protected StoreConfigurationBuilder addStore(PersistenceConfigurationBuilder persistenceConfigurationBuilder, boolean shared) {
        assert (!shared);
        return persistenceConfigurationBuilder.addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString());
    }

    public void testRestartWithNoIndex() throws Throwable {
        int i;
        int size = 10;
        for (i = 0; i < size; ++i) {
            this.cache(0, this.cacheName).put((Object)i, (Object)("value-" + i));
        }
        AssertJUnit.assertEquals((int)size, (int)this.cache(0, this.cacheName).size());
        this.killMember(0, this.cacheName);
        Util.recursiveFileRemove((Path)Paths.get(this.tmpDirectory, "index"));
        this.createCacheManagers();
        AssertJUnit.assertEquals((int)size, (int)this.cache(0, this.cacheName).size());
        for (i = 0; i < size; ++i) {
            AssertJUnit.assertEquals((Object)("value-" + i), (Object)this.cache(0, this.cacheName).get((Object)i));
        }
    }
}

