/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.file.Paths;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.BaseNonBlockingStoreTest;
import org.infinispan.persistence.sifs.NonBlockingSoftIndexFileStore;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.sifs.SoftIndexFileStoreTest")
public class SoftIndexFileStoreTest
extends BaseNonBlockingStoreTest {
    protected String tmpDirectory;

    @BeforeClass(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected NonBlockingStore createStore() {
        return new NonBlockingSoftIndexFileStore();
    }

    @Override
    protected Configuration buildConfig(ConfigurationBuilder configurationBuilder) {
        return configurationBuilder.persistence().addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString()).maxFileSize(1000).build();
    }

    public void testOverrideWithExpirableAndCompaction() throws InterruptedException {
        this.store.write(this.marshalledEntry(this.internalCacheEntry("key", "value1", -1L)));
        this.writeGibberish();
        this.store.write(this.marshalledEntry(this.internalCacheEntry("key", "value2", 1L)));
        this.timeService.advance(2L);
        this.writeGibberish();
        this.store.stop();
        this.startStore(this.store);
        MarshallableEntry entry = this.store.loadEntry("key");
        AssertJUnit.assertNull(entry != null ? entry.getKey() + "=" + entry.getValue() : null, (Object)entry);
    }

    private void writeGibberish() {
        for (int i = 0; i < 100; ++i) {
            this.store.write(this.marshalledEntry(this.internalCacheEntry("foo", "bar", -1L)));
            this.store.delete("foo");
        }
    }
}

