/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfiguration;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletableFutures;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.decorators.AsyncStoreEvictionTest")
public class AsyncStoreEvictionTest
extends AbstractInfinispanTest {
    private static final boolean USE_ASYNC_STORE = true;
    private static final ThreadLocal<LockableStore> STORE = new ThreadLocal();

    private static ConfigurationBuilder config(boolean passivation, int threads) {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.expiration().wakeUpInterval(100L);
        config.memory().size(1L);
        ((LockableStoreConfigurationBuilder)config.persistence().passivation(passivation).addStore(LockableStoreConfigurationBuilder.class)).async().enabled(true);
        return config;
    }

    public void testEndToEndEvictionPassivation() throws Exception {
        this.testEndToEndEviction(true);
    }

    public void testEndToEndEviction() throws Exception {
        this.testEndToEndEviction(false);
    }

    private void testEndToEndEviction(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(passivation, 1)){

            @Override
            public void call() {
                this.store.future = new CompletableFuture();
                try {
                    this.cache.put((Object)"k1", (Object)"v1");
                    this.cache.put((Object)"k2", (Object)"v2");
                    TestingUtil.sleepThread(100L);
                    this.cache.put((Object)"k3", (Object)"v3");
                    this.cache.put((Object)"k4", (Object)"v4");
                    assert ("v3".equals(this.cache.get((Object)"k3"))) : "cache must return k3 == v3 (was: " + (String)this.cache.get((Object)"k3") + ")";
                }
                finally {
                    this.store.future.complete(null);
                }
            }
        });
    }

    public void testEndToEndUpdatePassivation() throws Exception {
        this.testEndToEndUpdate(true);
    }

    public void testEndToEndUpdate() throws Exception {
        this.testEndToEndUpdate(false);
    }

    private void testEndToEndUpdate(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(passivation, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v0");
                this.cache.put((Object)"k2", (Object)"v2");
                AsyncStoreEvictionTest.this.eventually(new AbstractInfinispanTest.Condition(){

                    @Override
                    public boolean isSatisfied() throws Exception {
                        return store.loadEntry("k1") != null;
                    }
                });
                this.store.future = new CompletableFuture();
                try {
                    this.cache.put((Object)"k3", (Object)"v3");
                    this.cache.put((Object)"k4", (Object)"v4");
                    TestingUtil.sleepThread(100L);
                    this.cache.put((Object)"k1", (Object)"v1");
                    this.cache.put((Object)"k5", (Object)"v5");
                    assert ("v1".equals(this.cache.get((Object)"k1"))) : "cache must return k1 == v1 (was: " + (String)this.cache.get((Object)"k1") + ")";
                }
                finally {
                    this.store.future.complete(null);
                }
            }
        });
    }

    public void testEndToEndRemovePassivation() throws Exception {
        this.testEndToEndRemove(true);
    }

    public void testEndToEndRemove() throws Exception {
        this.testEndToEndRemove(false);
    }

    private void testEndToEndRemove(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(passivation, 2)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                AsyncStoreEvictionTest.this.eventually(() -> this.store.loadEntry("k1") != null);
                this.store.future = new CompletableFuture();
                try {
                    this.cache.remove((Object)"k1");
                    TestingUtil.sleepThread(100L);
                    this.cache.remove((Object)"k1");
                    TestingUtil.sleepThread(200L);
                    assert (null == this.cache.get((Object)"k1")) : "cache must return k1 == null (was: " + (String)this.cache.get((Object)"k1") + ")";
                }
                finally {
                    this.store.future.complete(null);
                }
            }
        });
    }

    public void testNPE() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.remove((Object)"k1");
                this.cache.put((Object)"k2", (Object)"v2");
            }
        });
    }

    public void testLIRS() throws Exception {
        ConfigurationBuilder config = AsyncStoreEvictionTest.config(false, 1);
        config.memory().size(1L);
        TestingUtil.withCacheManager(new CacheCallable(config){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                this.cache.put((Object)"k1", (Object)"v3");
                this.cache.put((Object)"k2", (Object)"v4");
                this.cache.put((Object)"k3", (Object)"v3");
                this.cache.put((Object)"k4", (Object)"v4");
            }
        });
    }

    public void testSize() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                AssertJUnit.assertEquals((String)"cache size must be 1", (int)1, (int)this.cache.getAdvancedCache().getDataContainer().size());
            }
        });
    }

    public void testSizeAfterExpiration() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                TestingUtil.sleepThread(200L);
                AssertJUnit.assertFalse((String)"expiry doesn't work even after expiration", (2 == this.cache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
            }
        });
    }

    public void testSizeAfterEvict() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.evict((Object)"k1");
                AssertJUnit.assertEquals((String)"cache size must be 0", (int)0, (int)this.cache.getAdvancedCache().getDataContainer().size());
            }
        });
    }

    public void testSizeAfterRemove() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.remove((Object)"k1");
                AssertJUnit.assertEquals((String)"cache size must be 0", (int)0, (int)this.cache.getAdvancedCache().getDataContainer().size());
            }
        });
    }

    private static abstract class CacheCallable
    extends CacheManagerCallable {
        protected final Cache<String, String> cache;
        protected final LockableStore store;

        CacheCallable(ConfigurationBuilder builder) {
            super(TestCacheManagerFactory.createCacheManager(builder));
            this.cache = this.cm.getCache();
            this.store = (LockableStore)STORE.get();
        }
    }

    public static class LockableStore
    extends DummyInMemoryStore {
        private volatile CompletableFuture<Void> future = CompletableFutures.completedNull();

        public LockableStore() {
            STORE.set(this);
        }

        @Override
        public CompletionStage<Void> write(int segment, MarshallableEntry entry) {
            return this.future.thenCompose(ignore -> super.write(segment, entry));
        }

        @Override
        public CompletionStage<Boolean> delete(int segment, Object key) {
            return this.future.thenCompose(ignore -> super.delete(segment, key));
        }
    }

    @ConfigurationFor(value=LockableStore.class)
    @BuiltBy(value=LockableStoreConfigurationBuilder.class)
    public static class LockableStoreConfiguration
    extends DummyInMemoryStoreConfiguration {
        public LockableStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
            super(attributes, async);
        }
    }

    public static class LockableStoreConfigurationBuilder
    extends DummyInMemoryStoreConfigurationBuilder {
        public LockableStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
            super(builder);
        }

        @Override
        public LockableStoreConfiguration create() {
            return new LockableStoreConfiguration(this.attributes.protect(), this.async.create());
        }
    }
}

