/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.decorators.BatchAsyncStoreTest")
public class BatchAsyncStoreTest
extends SingleCacheManagerTest {
    private final HashMap<Object, Object> cacheCopy = new HashMap();
    private String tmpDirectory;

    public BatchAsyncStoreTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.globalState().enable().persistentLocation(this.tmpDirectory);
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        configuration.invocationBatching().enable();
        this.enableTestJdbcStorage(configuration);
        return TestCacheManagerFactory.createCacheManager(globalBuilder, configuration);
    }

    private void enableTestJdbcStorage(ConfigurationBuilder configuration) throws Exception {
        configuration.persistence().addSingleFileStore().async().enable();
    }

    @Test
    public void sequentialOverwritingInBatches() {
        this.cache = this.cacheManager.getCache();
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        int i = 0;
        while (i < 2000) {
            advancedCache.startBatch();
            this.putAValue((AdvancedCache<Object, Object>)advancedCache, i++);
            this.putAValue((AdvancedCache<Object, Object>)advancedCache, i++);
            advancedCache.endBatch(true);
        }
        this.cacheCopy.putAll((Map<Object, Object>)this.cache);
        this.cache.stop();
        this.cacheManager.stop();
    }

    private void putAValue(AdvancedCache<Object, Object> advancedCache, int i) {
        String key = "k" + i % 13;
        String value = "V" + i;
        advancedCache.put((Object)key, (Object)value);
    }

    @Test(dependsOnMethods={"sequentialOverwritingInBatches"})
    public void indexWasStored() {
        this.cache = this.cacheManager.getCache();
        Assert.assertEquals((int)0, (int)this.cache.getAdvancedCache().getDataContainer().size());
        boolean failed = false;
        for (Object key : this.cacheCopy.keySet()) {
            Object actual;
            Object expected = this.cacheCopy.get(key);
            if (expected.equals(actual = this.cache.get(key))) continue;
            log.errorf("Failure on key '%s' expected value: '%s' actual value: '%s'", (Object)key.toString(), expected, actual);
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
        Assert.assertEquals((int)this.cacheCopy.keySet().size(), (int)this.cache.keySet().size(), (String)"have a different number of keys");
    }

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }
}

