/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.support.DelayStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.support.ReplAsyncStoreTest")
public class ReplAsyncStoreTest
extends MultipleCacheManagersTest {
    protected final String CACHE_NAME = "testCache";
    private boolean shared;

    ReplAsyncStoreTest shared(boolean shared) {
        this.shared = shared;
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new ReplAsyncStoreTest().shared(false), new ReplAsyncStoreTest().shared(true)};
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"shared"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.shared};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = ReplAsyncStoreTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        ((DummyInMemoryStoreConfigurationBuilder)((DelayStore.ConfigurationBuilder)cfg.persistence().addStore(DelayStore.ConfigurationBuilder.class)).storeName(this.shared ? ReplAsyncStoreTest.class.getName() : null).shared(this.shared)).async().enable();
        this.createClusteredCaches(3, "testCache", TestDataSCI.INSTANCE, cfg);
        this.waitForClusterToForm("testCache");
    }

    @DataProvider(name="async-ops")
    public Object[][] asyncOperationProvider() {
        return (Object[][])Stream.of(Op.values()).flatMap(op -> Stream.of(true, false).map(bool -> new Object[]{bool, op})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="async-ops")
    public void testOperationAfterInsertAndEvict(boolean primary, Op consumer) {
        Cache primaryOwner = this.cache(0, "testCache");
        Cache backupOwner = this.cache(1, "testCache");
        MagicKey key = this.getKeyForCache(primaryOwner);
        DelayStore primaryStore = (DelayStore)TestingUtil.getFirstStore(primaryOwner);
        primaryStore.delayBeforeModification(1);
        DelayStore backupStore = (DelayStore)TestingUtil.getFirstStore(backupOwner);
        backupStore.delayBeforeModification(1);
        primaryOwner.put((Object)key, (Object)"some-value");
        Cache cacheToUse = primary ? primaryOwner : backupOwner;
        cacheToUse.evict((Object)key);
        consumer.perform(key, cacheToUse);
        primaryStore.endDelay();
        backupStore.endDelay();
    }

    static enum Op {
        SIZE{

            @Override
            void perform(MagicKey key, Cache<MagicKey, String> cache) {
                AssertJUnit.assertEquals((int)1, (int)cache.size());
            }
        }
        ,
        KEY_ITERATOR{

            @Override
            void perform(MagicKey key, Cache<MagicKey, String> cache) {
                CloseableIterator iterator = cache.keySet().iterator();
                AssertJUnit.assertTrue((boolean)iterator.hasNext());
                AssertJUnit.assertEquals((Object)key, iterator.next());
                AssertJUnit.assertFalse((boolean)iterator.hasNext());
            }
        }
        ,
        ENTRY_COLLECT{

            @Override
            void perform(MagicKey key, Cache<MagicKey, String> cache) {
                List list = (List)cache.entrySet().stream().collect(Collectors::toList);
                AssertJUnit.assertEquals((int)1, (int)list.size());
                AssertJUnit.assertEquals((Object)key, ((Map.Entry)list.get(0)).getKey());
            }
        };


        abstract void perform(MagicKey var1, Cache<MagicKey, String> var2);
    }
}

