/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.util.concurrent.CompletionStages;
import org.reactivestreams.Publisher;

public interface WaitNonBlockingStore<K, V>
extends NonBlockingStore<K, V> {
    public KeyPartitioner getKeyPartitioner();

    default public Boolean delete(Object key) {
        int segment = this.getKeyPartitioner().getSegment(key);
        return (Boolean)this.join(this.delete(segment, key));
    }

    default public boolean contains(Object key) {
        int segment = this.getKeyPartitioner().getSegment(key);
        return (Boolean)this.join(this.containsKey(segment, key));
    }

    default public MarshallableEntry<K, V> loadEntry(Object key) {
        int segment = this.getKeyPartitioner().getSegment(key);
        return (MarshallableEntry)this.join(this.load(segment, key));
    }

    default public void write(MarshallableEntry<K, V> entry) {
        int segment = this.getKeyPartitioner().getSegment(entry.getKey());
        this.join(this.write(segment, entry));
    }

    default public void batchUpdate(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        this.join(this.batch(publisherCount, removePublisher, writePublisher));
    }

    default public boolean checkAvailable() {
        return (Boolean)this.join(this.isAvailable());
    }

    default public long sizeWait(IntSet segments) {
        return (Long)this.join(this.size(segments));
    }

    default public long approximateSizeWait(IntSet segments) {
        return (Long)this.join(this.approximateSize(segments));
    }

    default public void clearAndWait() {
        this.join(this.clear());
    }

    default public void startAndWait(InitializationContext ctx) {
        this.join(this.start(ctx));
    }

    default public void stopAndWait() {
        this.join(this.stop());
    }

    default public List<K> publishKeysWait(IntSet segments, Predicate<? super K> filter) {
        return (List)this.join(Flowable.fromPublisher((Publisher)this.publishKeys(segments, filter)).collect(Collectors.toList()).toCompletionStage());
    }

    default public List<MarshallableEntry<K, V>> publishEntriesWait(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return (List)this.join(Flowable.fromPublisher((Publisher)this.publishEntries(segments, filter, includeValues)).collect(Collectors.toList()).toCompletionStage());
    }

    default public List<MarshallableEntry<K, V>> purge() {
        return (List)this.join(Flowable.fromPublisher((Publisher)this.purgeExpired()).collect(Collectors.toList()).toCompletionStage());
    }

    default public <V> V join(CompletionStage<V> stage) {
        return (V)CompletionStages.join(stage);
    }
}

