/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="profiling.MemConsumptionTest")
public class MemConsumptionTest
extends AbstractInfinispanTest {
    int numEntries = 1000000;
    int payloadSize = 60;
    int keySize = 10;
    PayloadType payloadType = PayloadType.STRINGS;
    int bytesPerCharacter = 2;
    Random r = new Random();

    public void testMemConsumption() throws IOException {
        int kBytesCached = this.bytesPerCharacter * this.numEntries * (this.payloadSize + this.keySize) / 1024;
        System.out.println("Bytes to be cached: " + NumberFormat.getIntegerInstance().format(kBytesCached) + " kb");
        Cache c = TestCacheManagerFactory.createCacheManager().getCache();
        for (int i = 0; i < this.numEntries; ++i) {
            switch (this.payloadType) {
                case STRINGS: {
                    c.put((Object)this.generateUniqueString(i, this.keySize), (Object)this.generateRandomString(this.payloadSize));
                    break;
                }
                case BYTE_ARRAYS: {
                    c.put((Object)this.generateUniqueKey(i, this.keySize), (Object)this.generateBytePayload(this.payloadSize));
                    break;
                }
                default: {
                    throw new CacheException("Unknown payload type");
                }
            }
            if (i % 1000 != 0) continue;
            System.out.println("Added " + i + " entries");
        }
        System.out.println("Calling System.gc()");
        System.gc();
        TestingUtil.sleepThread(1000L);
        System.out.println("Cache populated; check mem usage using jconsole, etc.!");
        System.in.read();
    }

    private String generateUniqueString(int runNumber, int keySize) {
        StringBuilder sb = new StringBuilder();
        sb.append(runNumber);
        for (int i = sb.length(); i < keySize; ++i) {
            sb.append("_");
        }
        return sb.toString();
    }

    private byte[] generateUniqueKey(int runNumber, int keySize) {
        byte[] b = new byte[keySize];
        b[0] = (byte)runNumber;
        b[1] = (byte)(runNumber >>> 8);
        b[2] = (byte)(runNumber >>> 16);
        b[3] = (byte)(runNumber >>> 24);
        for (int i = 4; i < keySize; ++i) {
            b[i] = 0;
        }
        return b;
    }

    private byte[] generateBytePayload(int payloadSize) {
        byte[] b = new byte[payloadSize];
        Arrays.fill(b, (byte)0);
        return b;
    }

    private String generateRandomString(int stringSize) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringSize; ++i) {
            sb.append(this.r.nextInt(9));
        }
        assert (sb.length() == stringSize);
        return sb.toString();
    }

    static enum PayloadType {
        STRINGS,
        BYTE_ARRAYS;

    }
}

