/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.profiling.AbstractProfileTest;
import org.infinispan.profiling.testinternals.Generator;
import org.infinispan.profiling.testinternals.TaskRunner;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="profiling.ProfileTest")
public class ProfileTest
extends AbstractProfileTest {
    protected static long NUM_OPERATIONS = 1000000L;
    protected static final int NUM_THREADS = 25;
    protected static final int MAX_RANDOM_SLEEP_MILLIS = 1;
    protected static final int MAX_OVERALL_KEYS = 2000;
    protected static final int WARMUP_LOOPS = 20000;
    protected static final boolean USE_SLEEP = false;
    protected static final boolean SKIP_WARMUP = true;
    private List<Object> keys = new ArrayList<Object>(2000);
    protected static boolean USE_TRANSACTIONS = false;

    public static void main(String[] args) throws Exception {
        ProfileTest pst = new ProfileTest();
        pst.startedInCmdLine = true;
        String mode = args[0];
        if (args.length > 1) {
            USE_TRANSACTIONS = Boolean.parseBoolean(args[1]);
        }
        try {
            if (args.length > 1) {
                pst.clusterNameOverride = args[1];
            }
            pst.testWith(mode);
        }
        finally {
            pst.destroyAfterMethod();
            pst.destroyAfterClass();
        }
    }

    protected void testWith(String cacheName) throws Exception {
        log.warnf("Starting profile test, cache name = %s", (Object)cacheName);
        this.initTest();
        this.cache = this.cacheManager.getCache(cacheName);
        this.runCompleteTest(cacheName);
    }

    public void testLocalMode() throws Exception {
        this.runCompleteTest("local");
    }

    public void testReplMode() throws Exception {
        this.runCompleteTest("repl_sync");
    }

    private void runCompleteTest(String cacheName) throws Exception {
        this.cache = this.cacheManager.getCache(cacheName);
        this.init();
        this.startup();
        if (!cacheName.equals("local")) {
            System.out.println("Waiting for members to join.");
            TestingUtil.blockUntilViewReceived(this.cache, 2, 120000L, true);
            System.out.println("Cluster ready, cache mode is " + this.cache.getCacheConfiguration().clustering().cacheMode());
        }
        this.warmup();
        this.doTest();
    }

    protected void init() {
        long startTime = System.currentTimeMillis();
        log.warn((Object)"Starting init() phase");
        this.keys.clear();
        for (int i = 0; i < 2000; ++i) {
            Object key;
            while (this.keys.contains(key = Generator.createRandomKey())) {
            }
            if (i % 10 == 0) {
                log.trace((Object)("Generated " + i + " keys"));
            }
            this.keys.add(key);
        }
        System.gc();
        long duration = System.currentTimeMillis() - startTime;
        log.warn((Object)("Finished init() phase.  " + this.printDuration(duration)));
    }

    protected void startup() {
        long startTime = System.currentTimeMillis();
        log.warn((Object)"Starting cache");
        this.cache.start();
        long duration = System.currentTimeMillis() - startTime;
        log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    private void warmup() throws InterruptedException {
        log.info((Object)"Skipping warmup; sleeping 3 secs");
        TestingUtil.sleepThread(3000L);
    }

    private void doTest() throws Exception {
        TaskRunner exec = new TaskRunner(25);
        log.warn((Object)"Starting test");
        long print = NUM_OPERATIONS / 10L;
        AtomicLong durationPuts = new AtomicLong();
        AtomicLong durationGets = new AtomicLong();
        AtomicLong durationRemoves = new AtomicLong();
        long stElapsed = System.nanoTime();
        int i = 0;
        while ((long)i < NUM_OPERATIONS) {
            MyRunnable r = null;
            switch (i % 3) {
                case 0: {
                    r = new Putter(i, durationPuts);
                    break;
                }
                case 1: {
                    r = new Getter(i, durationGets);
                    break;
                }
                case 2: {
                    r = new Remover(i, durationRemoves);
                }
            }
            if ((long)i % print == 0L) {
                log.warn((Object)("processing iteration " + i));
            }
            exec.execute(r);
            ++i;
        }
        log.warn((Object)"Finished generating runnables; awaiting executor completion");
        exec.stop();
        long elapsedTimeNanos = System.nanoTime() - stElapsed;
        log.warn((Object)("Finished test.  " + this.printDuration((long)this.toMillis(elapsedTimeNanos))));
        log.warn((Object)("Throughput: " + (double)NUM_OPERATIONS * 1000.0 / this.toMillis(elapsedTimeNanos) + " operations per second (roughly equal numbers of PUT, GET and REMOVE)"));
        log.warn((Object)("Average GET time: " + this.printAvg(durationGets.get())));
        log.warn((Object)("Average PUT time: " + this.printAvg(durationPuts.get())));
        log.warn((Object)("Average REMOVE time: " + this.printAvg(durationRemoves.get())));
    }

    private String printAvg(long totalNanos) {
        double nOps = NUM_OPERATIONS / 3L;
        double avg = (double)totalNanos / nOps;
        double avgMicros = avg / 1000.0;
        return avgMicros + " \u00b5s";
    }

    private double toMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    protected String printDuration(long duration) {
        if (duration > 2000L) {
            double dSecs = (double)duration / 1000.0;
            return "Duration: " + dSecs + " seconds";
        }
        return "Duration: " + duration + " millis";
    }

    private class Remover
    extends MyRunnable {
        private Remover(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.REMOVE;
        }
    }

    private class Getter
    extends MyRunnable {
        private Getter(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.GET;
        }
    }

    private class Putter
    extends MyRunnable {
        private Putter(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.PUT;
        }
    }

    private abstract class MyRunnable
    implements Runnable {
        int id;
        Mode mode;
        AtomicLong duration;

        private MyRunnable() {
        }

        @Override
        public void run() {
            try {
                Object key = Generator.getRandomElement(ProfileTest.this.keys);
                long d = 0L;
                long st = 0L;
                switch (this.mode) {
                    case PUT: {
                        String value = Generator.getRandomString();
                        st = System.nanoTime();
                        if (USE_TRANSACTIONS) {
                            TestingUtil.getTransactionManager(ProfileTest.this.cache).begin();
                        }
                        ProfileTest.this.cache.put(key, (Object)value);
                        if (USE_TRANSACTIONS) {
                            TestingUtil.getTransactionManager(ProfileTest.this.cache).commit();
                        }
                        d = System.nanoTime() - st;
                        break;
                    }
                    case GET: {
                        st = System.nanoTime();
                        if (USE_TRANSACTIONS) {
                            TestingUtil.getTransactionManager(ProfileTest.this.cache).begin();
                        }
                        ProfileTest.this.cache.get(key);
                        if (USE_TRANSACTIONS) {
                            TestingUtil.getTransactionManager(ProfileTest.this.cache).commit();
                        }
                        d = System.nanoTime() - st;
                        break;
                    }
                    case REMOVE: {
                        st = System.nanoTime();
                        if (USE_TRANSACTIONS) {
                            TestingUtil.getTransactionManager(ProfileTest.this.cache).begin();
                        }
                        ProfileTest.this.cache.remove(key);
                        if (USE_TRANSACTIONS) {
                            TestingUtil.getTransactionManager(ProfileTest.this.cache).commit();
                        }
                        d = System.nanoTime() - st;
                    }
                }
                this.duration.getAndAdd(d);
            }
            catch (Exception e) {
                log.error((Object)"Caught ", (Throwable)e);
            }
        }
    }

    static enum Mode {
        PUT,
        GET,
        REMOVE;

    }
}

