/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.profiling.AbstractProfileTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="profiling.TestProfileSlave")
public class TestProfileSlave
extends AbstractProfileTest {
    public static void main(String[] args) throws Exception {
        TestProfileSlave pst = new TestProfileSlave();
        pst.startedInCmdLine = true;
        String mode = args[0];
        try {
            pst.testWith(mode);
        }
        finally {
            pst.destroyAfterMethod();
            pst.destroyAfterClass();
        }
    }

    public void testReplSync() throws Exception {
        this.testWith("repl_sync");
    }

    public void testReplAsync() throws Exception {
        this.testWith("repl_async");
    }

    public void testDistSync() throws Exception {
        this.testWith("dist_sync");
    }

    public void testDistAsync() throws Exception {
        this.testWith("dist_async");
    }

    public void testDistSyncL1() throws Exception {
        this.testWith("dist_sync_l1");
    }

    public void testDistAsyncL1() throws Exception {
        this.testWith("dist_async_l1");
    }

    private void waitForTest() throws Exception {
        Thread t = new Thread("CompletionThread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        this.cacheManager.addListener((Object)new ShutdownHook(t));
        t.setDaemon(true);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doTest() {
    }

    protected void testWith(String cachename) throws Exception {
        log.warnf("Starting slave, cache name = %s", (Object)cachename);
        this.initTest();
        this.cache = this.cacheManager.getCache(cachename);
        System.out.println("Waiting for members to join.");
        TestingUtil.blockUntilViewReceived(this.cache, 2, 120000L, true);
        System.out.println("Cluster ready, cache mode is " + this.cache.getCacheConfiguration().clustering().cacheMode());
        System.out.println("Waiting for test completion.  Hit CTRL-C when done.");
        this.doTest();
        this.waitForTest();
    }

    @Listener
    public static final class ShutdownHook {
        final Thread completionThread;

        public ShutdownHook(Thread completionThread) {
            this.completionThread = completionThread;
        }

        @ViewChanged
        public void viewChanged(ViewChangedEvent vce) {
            System.out.println("Saw view change event " + vce);
            if (vce.getOldMembers().size() > vce.getNewMembers().size() && vce.getNewMembers().size() == 1 && vce.getNewMembers().contains(vce.getLocalAddress())) {
                this.completionThread.interrupt();
            }
        }
    }
}

