/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisher;
import org.infinispan.reactive.publisher.impl.SimpleClusterPublisherManagerTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="reactive.publisher.impl.SimpleLocalPublisherMangerTest")
@InCacheMode(value={CacheMode.REPL_SYNC, CacheMode.DIST_SYNC, CacheMode.SCATTERED_SYNC})
public class SimpleLocalPublisherMangerTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = SimpleLocalPublisherMangerTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        builder.clustering().hash().numSegments(10);
        this.createCluster(builder, 3);
        this.waitForClusterToForm();
    }

    private Map<Integer, String> insert(Cache<Integer, String> cache) {
        int amount = 14;
        HashMap<Integer, String> values = new HashMap<Integer, String>(amount);
        IntStream.range(0, amount).forEach(i -> values.put(i, "value-" + i));
        cache.putAll(values);
        return values;
    }

    private LocalPublisherManager<Integer, String> lpm(Cache<Integer, String> cache) {
        return TestingUtil.extractComponent(cache, LocalPublisherManager.class);
    }

    @DataProvider(name="GuaranteeEntry")
    public Object[][] collectionAndVersionsProvider() {
        return (Object[][])Arrays.stream(DeliveryGuarantee.values()).flatMap(dg -> Stream.of(Boolean.TRUE, Boolean.FALSE).map(entry -> new Object[]{dg, entry})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="GuaranteeEntry")
    public void testNoIntermediateOps(DeliveryGuarantee deliveryGuarantee, boolean isEntry) {
        Consumer<Object> assertConsumer;
        SegmentAwarePublisher publisher;
        Cache cache = this.cache(0);
        Map<Integer, String> inserted = this.insert(cache);
        LocalPublisherManager<Integer, String> lpm = this.lpm(cache);
        IntSet allSegments = IntSets.immutableRangeSet((int)10);
        if (isEntry) {
            publisher = lpm.keyPublisher(allSegments, null, null, false, deliveryGuarantee, Function.identity());
            assertConsumer = obj -> AssertJUnit.assertTrue((boolean)inserted.containsKey(obj));
        } else {
            publisher = lpm.entryPublisher(allSegments, null, null, false, deliveryGuarantee, Function.identity());
            assertConsumer = obj -> {
                Map.Entry entry = (Map.Entry)obj;
                Object value = inserted.get(entry.getKey());
                AssertJUnit.assertEquals(value, entry.getValue());
            };
        }
        DistributionManager dm = TestingUtil.extractComponent(cache, DistributionManager.class);
        IntSet localSegments = dm.getCacheTopology().getLocalReadSegments();
        int expected = SimpleClusterPublisherManagerTest.findHowManyInSegments(inserted.size(), localSegments, TestingUtil.extractComponent(cache, KeyPartitioner.class));
        Set results = (Set)Flowable.fromPublisher((Publisher)publisher).collectInto(new HashSet(), HashSet::add).blockingGet();
        AssertJUnit.assertEquals((int)expected, (int)results.size());
        results.forEach(assertConsumer);
    }
}

