/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.jgroups;

import java.util.Collections;
import java.util.Properties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.UDP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.UUID;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="remoting.jgroups.ChannelLookupTest", groups={"functional"})
public class ChannelLookupTest
extends AbstractInfinispanTest {
    static JChannel mockChannel = (JChannel)Mockito.mock(JChannel.class);
    private ProtocolStack ps = (ProtocolStack)Mockito.mock(ProtocolStack.class);
    private Address a = new UUID(1L, 1L);
    private View v = new View(this.a, 1L, Collections.singletonList(this.a));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelLookupTest() {
        Mockito.when((Object)mockChannel.getAddress()).thenReturn((Object)this.a);
        Mockito.when((Object)mockChannel.down((Event)Matchers.isA(Event.class))).thenReturn((Object)this.a);
        Mockito.when((Object)mockChannel.getView()).thenReturn((Object)this.v);
        Mockito.when((Object)mockChannel.getProtocolStack()).thenReturn((Object)this.ps);
        Mockito.when((Object)this.ps.getTransport()).thenReturn((Object)new UDP());
        EmbeddedCacheManager cm = null;
        try {
            GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
            gc.transport().defaultTransport().addProperty("channelLookup", (Object)DummyLookup.class.getName());
            cm = TestCacheManagerFactory.createClusteredCacheManager(gc, new ConfigurationBuilder());
            cm.start();
            cm.getCache();
            GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm);
            Transport t = (Transport)gcr.getComponent(Transport.class);
            AssertJUnit.assertNotNull((Object)t);
            AssertJUnit.assertTrue((boolean)(t instanceof JGroupsTransport));
            AssertJUnit.assertNotSame(JChannel.class, ((JGroupsTransport)t).getChannel().getClass());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public static class DummyLookup
    implements JGroupsChannelLookup {
        public JChannel getJGroupsChannel(Properties p) {
            return mockChannel;
        }

        public boolean shouldConnect() {
            return false;
        }

        public boolean shouldDisconnect() {
            return false;
        }

        public boolean shouldClose() {
            return false;
        }
    }
}

