/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.SleepingCacheRpcCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.FilterMapResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.rpc.RpcManagerTimeoutTest")
public class RpcManagerTimeoutTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "_cache_name_";

    @Test(expectedExceptions={TimeoutException.class})
    public void testTimeoutWithResponseFilter() {
        RpcManager rpcManager = this.advancedCache(0, CACHE_NAME).getRpcManager();
        final List members = rpcManager.getMembers();
        ResponseFilter filter = new ResponseFilter(){
            private int expectedResponses = 2;

            public boolean isAcceptable(Response response, Address sender) {
                if (sender.equals(members.get(2)) || sender.equals(members.get(3))) {
                    --this.expectedResponses;
                }
                return true;
            }

            public boolean needMoreResponses() {
                return this.expectedResponses > 0;
            }
        };
        this.doTest((ResponseCollector<?>)new FilterMapResponseCollector(filter, true, 2), false);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testTimeoutWithoutFilter() {
        this.doTest(null, false);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testTimeoutWithBroadcast() {
        this.doTest(null, true);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = RpcManagerTimeoutTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        this.createClusteredCaches(4, CACHE_NAME, builder);
        this.waitForClusterToForm(CACHE_NAME);
    }

    private void doTest(ResponseCollector<?> collector, boolean broadcast) {
        if (collector == null) {
            collector = VoidResponseCollector.ignoreLeavers();
        }
        RpcManager rpcManager = this.advancedCache(0, CACHE_NAME).getRpcManager();
        RpcOptions rpcOptions = new RpcOptions(DeliverOrder.NONE, 1000L, TimeUnit.MILLISECONDS);
        SleepingCacheRpcCommand command = new SleepingCacheRpcCommand(ByteString.fromString((String)CACHE_NAME), 5000L);
        if (broadcast) {
            rpcManager.blocking(rpcManager.invokeCommandOnAll((ReplicableCommand)command, (ResponseCollector)collector, rpcOptions));
        } else {
            List members = rpcManager.getMembers();
            ArrayList<Address> recipients = new ArrayList<Address>(2);
            recipients.add((Address)members.get(2));
            recipients.add((Address)members.get(3));
            rpcManager.blocking(rpcManager.invokeCommand(recipients, (ReplicableCommand)command, (ResponseCollector)collector, rpcOptions));
        }
        Assert.fail((String)"Timeout exception wasn't thrown");
    }
}

