/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class SleepingCacheRpcCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 125;
    private long sleepTime;

    public SleepingCacheRpcCommand() {
        super(null);
    }

    public SleepingCacheRpcCommand(ByteString cacheName) {
        super(cacheName);
    }

    public SleepingCacheRpcCommand(ByteString cacheName, long sleepTime) {
        super(cacheName);
        this.sleepTime = sleepTime;
    }

    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        Thread.sleep(this.sleepTime);
        return CompletableFutures.completedNull();
    }

    public byte getCommandId() {
        return 125;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.sleepTime);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.sleepTime = input.readLong();
    }

    public boolean isReturnValueExpected() {
        return true;
    }
}

