/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.AbstractDelegatingTransport;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.testng.AssertJUnit;

public class ControlledTransport
extends AbstractDelegatingTransport {
    private static final Log log = LogFactory.getLog(ControlledTransport.class);
    private static final Predicate<ReplicableCommand> NEVER = cmd -> false;
    private final ReclosableLatch replicationLatch = new ReclosableLatch(true);
    private final ReclosableLatch blockingLatch = new ReclosableLatch(true);
    private volatile Predicate<ReplicableCommand> blockBeforeFilter = NEVER;
    private volatile Predicate<ReplicableCommand> blockAfterFilter = NEVER;
    private volatile Predicate<ReplicableCommand> failFilter = NEVER;

    private ControlledTransport(Transport realOne) {
        super(realOne);
    }

    public static ControlledTransport replace(Cache<?, ?> cache) {
        return ControlledTransport.replace(cache.getCacheManager());
    }

    public static ControlledTransport replace(EmbeddedCacheManager manager) {
        log.tracef("Replacing transport on %s", (Object)manager.getAddress());
        return TestingUtil.wrapGlobalComponent((CacheContainer)manager, Transport.class, ControlledTransport::new, true);
    }

    public void start() {
    }

    public void failFor(Class ... filter) {
        this.failFor(this.classListToFilter(filter));
    }

    private void failFor(Predicate<ReplicableCommand> filter) {
        this.failFilter = filter;
        this.blockingLatch.open();
    }

    public void stopFailing() {
        this.failFilter = NEVER;
        this.blockingLatch.open();
    }

    public void blockBefore(Class ... filter) {
        this.blockBefore(this.classListToFilter(filter));
    }

    public <T extends ReplicableCommand> void blockBefore(Class<T> commandClass, Predicate<T> filter) {
        this.blockBefore((ReplicableCommand c) -> commandClass.isInstance(c) && filter.test((ReplicableCommand)commandClass.cast(c)));
    }

    public void blockBefore(Predicate<ReplicableCommand> filter) {
        this.blockBeforeFilter = filter;
        this.replicationLatch.close();
        this.blockingLatch.close();
    }

    public void blockAfter(Class ... filter) {
        this.blockAfter(this.classListToFilter(filter));
    }

    public <T extends ReplicableCommand> void blockAfter(Class<T> commandClass, Predicate<T> filter) {
        this.blockAfter((ReplicableCommand c) -> commandClass.isInstance(c) && filter.test((ReplicableCommand)commandClass.cast(c)));
    }

    public void blockAfter(Predicate<ReplicableCommand> filter) {
        this.blockAfterFilter = filter;
        this.replicationLatch.close();
        this.blockingLatch.close();
    }

    public void stopBlocking() {
        log.tracef("Stop blocking commands", new Object[0]);
        this.blockBeforeFilter = NEVER;
        this.blockAfterFilter = NEVER;
        this.replicationLatch.open();
        this.blockingLatch.open();
    }

    public void waitForCommandToBlock() throws InterruptedException {
        log.tracef("Waiting for at least one command to block on %s", (Object)this.actual.getAddress());
        AssertJUnit.assertTrue((boolean)this.blockingLatch.await(30L, TimeUnit.SECONDS));
    }

    public boolean waitForCommandToBlock(long time, TimeUnit unit) throws InterruptedException {
        log.tracef("Waiting for at least one command to block", new Object[0]);
        return this.blockingLatch.await(time, unit);
    }

    public void failIfNeeded(ReplicableCommand rpcCommand) {
        if (this.failFilter.test(rpcCommand)) {
            log.tracef("Failing remote invocation of " + rpcCommand, new Object[0]);
            throw new IllegalStateException("Induced failure!");
        }
    }

    protected void waitBefore(ReplicableCommand rpcCommand) {
        this.waitForReplicationLatch("before", rpcCommand, this.blockBeforeFilter);
    }

    protected void waitAfter(ReplicableCommand rpcCommand) {
        this.waitForReplicationLatch("after", rpcCommand, this.blockAfterFilter);
    }

    protected void waitForReplicationLatch(String when, ReplicableCommand rpcCommand, Predicate<ReplicableCommand> filter) {
        if (!filter.test(rpcCommand)) {
            log.tracef("Not blocking %s command %s", (Object)when, (Object)rpcCommand);
            return;
        }
        try {
            if (!this.blockingLatch.isOpened()) {
                log.debugf("Replication trigger called, releasing any waiters for command to block.", new Object[0]);
                this.blockingLatch.open();
            }
            log.debugf("Replication trigger called, waiting for latch to open.", new Object[0]);
            AssertJUnit.assertTrue((boolean)this.replicationLatch.await(30L, TimeUnit.SECONDS));
            log.trace((Object)"Replication latch opened, continuing.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception!", e);
        }
    }

    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        this.failIfNeeded(command);
        this.waitBefore(command);
        return super.invokeCommand(target, command, collector, deliverOrder, timeout, unit).whenComplete((ignored, throwable) -> this.waitAfter(command));
    }

    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        this.failIfNeeded(command);
        this.waitBefore(command);
        return super.invokeCommand(targets, command, collector, deliverOrder, timeout, unit).whenComplete((ignored, throwable) -> this.waitAfter(command));
    }

    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        this.failIfNeeded(command);
        this.waitBefore(command);
        return super.invokeCommandOnAll(command, collector, deliverOrder, timeout, unit).whenComplete((ignored, throwable) -> this.waitAfter(command));
    }

    public <T> CompletionStage<T> invokeCommandOnAll(Collection<Address> requiredTargets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        this.failIfNeeded(command);
        this.waitBefore(command);
        return super.invokeCommandOnAll(requiredTargets, command, collector, deliverOrder, timeout, unit).whenComplete((ignored, throwable) -> this.waitAfter(command));
    }

    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, final ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        ResponseCollector partCollector = new ResponseCollector<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T addResponse(Address sender, Response response) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (result.get() != null) {
                        return null;
                    }
                    result.set(collector.addResponse(sender, response));
                    return null;
                }
            }

            public T finish() {
                return null;
            }
        };
        AggregateCompletionStage allStage = CompletionStages.aggregateCompletionStage();
        for (Address target : targets) {
            allStage.dependsOn(this.invokeCommand(target, commandGenerator.apply(target), partCollector, deliverOrder, timeout, timeUnit));
        }
        return allStage.freeze().thenApply(arg_0 -> ControlledTransport.lambda$invokeCommands$7((ResponseCollector)partCollector, result, collector, arg_0));
    }

    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> responseCollector, long timeout, DeliverOrder deliverOrder) {
        return this.invokeCommands(targets, commandGenerator, responseCollector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
    }

    public XSiteResponse backupRemotely(XSiteBackup backup, XSiteReplicateCommand rpcCommand) {
        this.failIfNeeded((ReplicableCommand)rpcCommand);
        this.waitBefore((ReplicableCommand)rpcCommand);
        XSiteResponse response = super.backupRemotely(backup, rpcCommand);
        response.whenComplete((ignored, throwable) -> this.waitAfter((ReplicableCommand)rpcCommand));
        return response;
    }

    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand rpcCommand) throws Exception {
        this.failIfNeeded((ReplicableCommand)rpcCommand);
        this.waitBefore((ReplicableCommand)rpcCommand);
        BackupResponse response = super.backupRemotely(backups, rpcCommand);
        response.notifyFinish(ignored -> this.waitAfter((ReplicableCommand)rpcCommand));
        response.notifyAsyncAck((sendTimestampNanos, siteName, throwable) -> this.waitAfter((ReplicableCommand)rpcCommand));
        return response;
    }

    public void sendTo(Address destination, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        super.sendTo(destination, rpcCommand, deliverOrder);
        this.waitAfter(rpcCommand);
    }

    public void sendToMany(Collection<Address> destinations, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        super.sendToMany(destinations, rpcCommand, deliverOrder);
        this.waitAfter(rpcCommand);
    }

    public void sendToAll(ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        super.sendToAll(rpcCommand, deliverOrder);
        this.waitAfter(rpcCommand);
    }

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        return super.invokeRemotelyAsync(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast).whenComplete((ignored, throwable) -> this.waitAfter(rpcCommand));
    }

    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        throw new UnsupportedOperationException();
    }

    private Predicate<ReplicableCommand> classListToFilter(Class<?>[] filter) {
        return cmd -> {
            Class<? extends ReplicableCommand> actualClass = this.getActualClass((ReplicableCommand)cmd);
            return Stream.of(filter).anyMatch(clazz -> clazz.isAssignableFrom(actualClass));
        };
    }

    private Class<? extends ReplicableCommand> getActualClass(ReplicableCommand rpcCommand) {
        Class<?> cmdClass = rpcCommand.getClass();
        if (cmdClass.equals(SingleRpcCommand.class)) {
            cmdClass = ((SingleRpcCommand)rpcCommand).getCommand().getClass();
        }
        return cmdClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object lambda$invokeCommands$7(ResponseCollector partCollector, AtomicReference result, ResponseCollector collector, Void v) {
        ResponseCollector responseCollector = partCollector;
        synchronized (responseCollector) {
            if (result.get() != null) {
                return result.get();
            }
            return collector.finish();
        }
    }
}

