/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.math.FieldElement;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="transport.InitialClusterSizeTest", groups={"functional"})
@CleanupAfterMethod
public class InitialClusterSizeTest
extends MultipleCacheManagersTest {
    public static final int CLUSTER_SIZE = 4;
    public static final int CLUSTER_TIMEOUT_SECONDS = 5;

    @Override
    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 4; ++i) {
            GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
            gc.transport().initialClusterSize(4).initialClusterTimeout(5L, TimeUnit.SECONDS);
            this.cacheManagers.add(TestCacheManagerFactory.createClusteredCacheManager(false, gc, InitialClusterSizeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC), new TransportFlags()));
        }
    }

    public void testInitialClusterSize() throws ExecutionException, InterruptedException, TimeoutException {
        Future[] threads = new Future[4];
        for (int i = 0; i < 4; ++i) {
            int index = i;
            threads[i] = this.fork(() -> this.manager(index).start());
        }
        for (Future f : threads) {
            f.get(15L, TimeUnit.SECONDS);
        }
        AssertJUnit.assertEquals((int)4, (int)this.manager(0).getMembers().size());
    }

    public <T extends FieldElement<T>> void testInitialClusterSizeFail() throws Throwable {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < 3; ++i) {
            EmbeddedCacheManager embeddedCacheManager = this.manager(i);
            futures.add(this.fork(() -> {
                manager.start();
                return null;
            }));
        }
        for (Future future : futures) {
            try {
                future.get(9L, TimeUnit.SECONDS);
                AssertJUnit.fail((String)"Should have thrown an exception");
            }
            catch (ExecutionException ee) {
                Exceptions.assertException(EmbeddedCacheManagerStartupException.class, org.infinispan.util.concurrent.TimeoutException.class, (String)"ISPN000399:.*", (Throwable)ee.getCause());
            }
        }
    }
}

