/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.AsyncAPITxSyncReplTest")
public class AsyncAPITxSyncReplTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfig();
        c.transaction().autoCommit(false);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, c);
    }

    protected ConfigurationBuilder getConfig() {
        return AsyncAPITxSyncReplTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
    }

    protected void assertOnAllCaches(Key k, String v, Cache c1, Cache c2) {
        AssertJUnit.assertEquals((String)"Error in cache 1.", (Object)v, (Object)c1.get((Object)k));
        AssertJUnit.assertEquals((String)"Error in cache 2,", (Object)v, (Object)c2.get((Object)k));
    }

    public void testAsyncTxMethods() throws Exception {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(1);
        String v = "v";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        String v5 = "v5";
        String v6 = "v6";
        String v_null = "v_nonexistent";
        Key key = new Key("k");
        TransactionManager tm = TestingUtil.getTransactionManager(c1);
        tm.begin();
        CompletableFuture f = c1.putAsync((Object)key, (Object)v);
        assert (f != null);
        Transaction t = tm.suspend();
        assert (c2.get((Object)key) == null);
        tm.resume(t);
        assert (f.get() == null);
        tm.commit();
        this.assertOnAllCaches(key, v, c1, c2);
        tm.begin();
        f = c1.putAsync((Object)key, (Object)v2);
        assert (f != null);
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v));
        tm.resume(t);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v));
        tm.commit();
        this.assertOnAllCaches(key, v2, c1, c2);
        tm.begin();
        CompletableFuture f2 = c1.putAllAsync(Collections.singletonMap(key, v3));
        assert (f2 != null);
        this.eventually(f2::isDone);
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v2));
        tm.resume(t);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        tm.commit();
        this.assertOnAllCaches(key, v3, c1, c2);
        tm.begin();
        CompletableFuture f1 = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f1 != null);
        this.eventually(f1::isDone);
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v3));
        tm.resume(t);
        assert (!f1.isCancelled());
        assert (f1.get().equals(v3));
        tm.commit();
        this.assertOnAllCaches(key, v3, c1, c2);
        tm.begin();
        CompletableFuture f3 = c1.removeAsync((Object)key);
        assert (f3 != null);
        this.eventually(f3::isDone);
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v3));
        tm.resume(t);
        assert (!f3.isCancelled());
        assert (f3.get().equals(v3));
        tm.commit();
        this.assertOnAllCaches(key, null, c1, c2);
        tm.begin();
        CompletableFuture f4 = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f4 != null);
        this.eventually(f4::isDone);
        assert (f4.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key) == null);
        tm.resume(t);
        assert (!f4.isCancelled());
        assert (f4.get() == null);
        tm.commit();
        this.assertOnAllCaches(key, v4, c1, c2);
        tm.begin();
        CompletableFuture f5 = c1.removeAsync((Object)key, (Object)v_null);
        assert (f5 != null);
        assert (!f5.isCancelled());
        assert (((Boolean)f5.get()).equals(false));
        assert (f5.isDone());
        tm.commit();
        this.assertOnAllCaches(key, v4, c1, c2);
        tm.begin();
        CompletableFuture f6 = c1.removeAsync((Object)key, (Object)v4);
        assert (f6 != null);
        this.eventually(f6::isDone);
        assert (f6.isDone());
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v4));
        tm.resume(t);
        assert (!f6.isCancelled());
        assert (f6.get().equals(true));
        tm.commit();
        this.assertOnAllCaches(key, null, c1, c2);
        tm.begin();
        CompletableFuture f7 = c1.replaceAsync((Object)key, (Object)v5);
        assert (f7 != null);
        assert (!f7.isCancelled());
        assert (f7.get() == null);
        assert (f7.isDone());
        tm.commit();
        this.assertOnAllCaches(key, null, c1, c2);
        tm.begin();
        c1.put((Object)key, (Object)v);
        tm.commit();
        tm.begin();
        CompletableFuture f8 = c1.replaceAsync((Object)key, (Object)v5);
        assert (f8 != null);
        this.eventually(f8::isDone);
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v));
        tm.resume(t);
        assert (!f8.isCancelled());
        assert (f8.get().equals(v));
        tm.commit();
        this.assertOnAllCaches(key, v5, c1, c2);
        tm.begin();
        CompletableFuture f9 = c1.replaceAsync((Object)key, (Object)v_null, (Object)v6);
        assert (f9 != null);
        assert (!f9.isCancelled());
        assert (f9.get().equals(false));
        assert (f9.isDone());
        tm.commit();
        this.assertOnAllCaches(key, v5, c1, c2);
        tm.begin();
        CompletableFuture f10 = c1.replaceAsync((Object)key, (Object)v5, (Object)v6);
        assert (f10 != null);
        this.eventually(f10::isDone);
        t = tm.suspend();
        assert (c2.get((Object)key).equals(v5));
        tm.resume(t);
        assert (!f10.isCancelled());
        assert (f10.get().equals(true));
        tm.commit();
        this.assertOnAllCaches(key, v6, c1, c2);
    }
}

