/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionalEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncCacheListenerTest")
public class SyncCacheListenerTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(SyncCacheListenerTest.class);
    private Cache<Object, Object> cache1;
    private Cache<Object, Object> cache2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = SyncCacheListenerTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        builder.locking().isolationLevel(IsolationLevel.SERIALIZABLE).transaction().useSynchronization(false);
        this.createClusteredCaches(2, "cache", builder);
        this.cache1 = this.cache(0, "cache");
        this.cache2 = this.cache(1, "cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncTxRepl() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache1);
        tm.begin();
        Transaction tx = tm.getTransaction();
        LocalListener lis = new LocalListener();
        this.cache1.addListener((Object)lis);
        try {
            lis.put("age", 38);
        }
        finally {
            this.cache1.removeListener((Object)lis);
        }
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get((Object)"age"));
        tm.resume(tx);
        tm.commit();
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertEquals((String)"\"age\" must be 38", (int)age, (int)38);
    }

    public void testRemoteCacheListener() throws Exception {
        RemoteListener lis = new RemoteListener();
        this.cache2.addListener((Object)lis);
        try {
            this.cache1.put((Object)"age", (Object)38);
            Integer age = (Integer)this.cache2.get((Object)"age");
            AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
            AssertJUnit.assertEquals((String)"\"age\" must be 38", (int)age, (int)38);
            this.cache1.remove((Object)"age");
        }
        finally {
            this.cache2.removeListener((Object)lis);
        }
    }

    public void testSyncRepl() throws Exception {
        LocalListener lis = new LocalListener();
        this.cache1.addListener((Object)lis);
        try {
            lis.put("age", 38);
        }
        finally {
            this.cache2.removeListener((Object)lis);
        }
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertEquals((String)"\"age\" must be 38", (int)age, (int)38);
    }

    public void simpleReplicationTest() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache1);
        tm.begin();
        this.cache1.put((Object)"key", (Object)"value");
        tm.commit();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get((Object)"key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncTxReplMap() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache1);
        tm.begin();
        Transaction tx = tm.getTransaction();
        LocalListener lis = new LocalListener();
        try {
            this.cache1.put((Object)"age", (Object)38);
            lis.put("name", "Ben");
        }
        finally {
            this.cache1.removeListener((Object)lis);
        }
        AssertJUnit.assertEquals((Object)38, (Object)this.cache1.get((Object)"age"));
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get((Object)"age"));
        AssertJUnit.assertNull((String)"age on cache1 must be null as the TX has been resumed", (Object)this.cache1.get((Object)"age"));
        tm.resume(tx);
        AssertJUnit.assertNotNull((String)"age on cache1 must be not be null", (Object)this.cache1.get((Object)"age"));
        tm.commit();
        AssertJUnit.assertNotNull((String)"age on cache1 must be not be null", (Object)this.cache1.get((Object)"age"));
        log.trace((Object)"  ********************** ");
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertEquals((String)"\"age\" must be 38", (int)age, (int)38);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncReplMap() throws Exception {
        LockManager lm1 = TestingUtil.extractComponent(this.cache1, LockManager.class);
        AssertJUnit.assertNull((String)("lock info is " + lm1.printLockInfo()), (Object)lm1.getOwner((Object)"age"));
        LocalListener lis = new LocalListener();
        this.cache1.addListener((Object)lis);
        try {
            lis.put("age", 38);
            this.cache1.put((Object)"name", (Object)"Ben");
        }
        finally {
            this.cache1.removeListener((Object)lis);
        }
        AssertJUnit.assertNull((String)("lock info is " + lm1.printLockInfo()), (Object)lm1.getOwner((Object)"age"));
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertEquals((String)"\"age\" must be 38", (int)age, (int)38);
        AssertJUnit.assertNull((String)("lock info is " + lm1.printLockInfo()), (Object)lm1.getOwner((Object)"age"));
    }

    @Listener
    public static class RemoteListener {
        @CacheEntryRemoved
        @CacheEntryModified
        public void callback(TransactionalEvent e) {
            log.trace((Object)("Callback got event " + e));
            log.debug((Object)("Callback got event " + e));
            AssertJUnit.assertFalse((String)"entry was removed on remote cache so isLocal should be false", (boolean)e.isOriginLocal());
        }
    }

    @Listener
    public class LocalListener {
        Object key = null;

        public void put(Object key, Object val) {
            this.key = key;
            SyncCacheListenerTest.this.cache1.put(key, val);
        }

        public void put(Map<?, ?> map) {
            if (map.isEmpty()) {
                AssertJUnit.fail((String)"put(): map size can't be 0");
            }
            SyncCacheListenerTest.this.cache1.putAll(map);
        }

        @CacheEntryModified
        public void modified(Event<Object, Object> ne) {
            if (!ne.isPre()) {
                log.debug((Object)("modified visited with key: " + this.key));
                try {
                    SyncCacheListenerTest.this.cache1.get(this.key);
                }
                catch (CacheException e) {
                    log.error((Object)"Error reading the cache", (Throwable)e);
                    throw e;
                }
            }
        }
    }
}

