/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.scattered.BaseScatteredTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scattered.APIScatteredTest")
public class APIScatteredTest
extends BaseScatteredTest {
    private static final String VALUE1 = "VALUE1";
    private static final String VALUE2 = "VALUE2";
    private static final String VALUE3 = "VALUE3";

    @Override
    public Object[] factory() {
        return new Object[]{new APIScatteredTest().biasAcquisition(BiasAcquisition.NEVER), new APIScatteredTest().biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    public void testPut() {
        this.testPut(false);
    }

    public void testGetAndPut() {
        this.testPut(true);
    }

    private void testPut(boolean returnValue) {
        MagicKey KEY = new MagicKey(this.cache(0));
        Assert.assertNull((Object)this.cacheWithFlags(0, returnValue).put((Object)KEY, (Object)VALUE1));
        Assert.assertTrue((boolean)this.dc(0).containsKey((Object)KEY));
        Assert.assertTrue((boolean)this.dc(1).containsKey((Object)KEY));
        Assert.assertFalse((boolean)this.dc(2).containsKey((Object)KEY));
        this.checkCaches(KEY, VALUE1);
        Assert.assertEquals((Object)this.cacheWithFlags(1, returnValue).put((Object)KEY, (Object)VALUE2), (Object)(returnValue ? VALUE1 : null));
        Assert.assertEquals((Object)this.dc(0).peek((Object)KEY).getValue(), (Object)VALUE2);
        Assert.assertEquals((Object)this.dc(1).peek((Object)KEY).getValue(), (Object)VALUE2);
        Assert.assertFalse((boolean)this.dc(2).containsKey((Object)KEY));
        this.checkCaches(KEY, VALUE2);
        Assert.assertEquals((Object)this.cacheWithFlags(2, returnValue).put((Object)KEY, (Object)VALUE3), (Object)(returnValue ? VALUE2 : null));
        Assert.assertEquals((Object)this.dc(0).peek((Object)KEY).getValue(), (Object)VALUE3);
        Assert.assertEquals((Object)this.dc(2).peek((Object)KEY).getValue(), (Object)VALUE3);
        InternalCacheEntry entry1 = this.dc(1).peek((Object)KEY);
        Assert.assertEquals((Object)entry1.getValue(), (Object)VALUE2);
        this.checkCaches(KEY, VALUE3);
        this.flush(false);
        Assert.assertFalse((boolean)this.dc(1).containsKey((Object)KEY));
    }

    private Cache<Object, Object> cacheWithFlags(int node, boolean returnValue) {
        if (returnValue) {
            return this.cache(node);
        }
        return this.cache(node).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
    }

    private void checkCaches(MagicKey key1, String VALUE1) {
        for (Cache c : this.caches()) {
            Assert.assertEquals((Object)c.get((Object)key1), (Object)VALUE1);
        }
    }

    public void testRemove() {
        MagicKey KEY = new MagicKey(this.cache(0));
        this.cache(0).put((Object)KEY, (Object)VALUE1);
        EntryVersion oldVersion = this.dc(0).peek((Object)KEY).getMetadata().version();
        Assert.assertEquals((Object)this.cache(0).remove((Object)KEY), (Object)VALUE1);
        InternalCacheEntry entry = this.dc(0).peek((Object)KEY);
        AssertJUnit.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        AssertJUnit.assertNotNull((Object)entry.getMetadata());
        EntryVersion removedVersion = entry.getMetadata().version();
        AssertJUnit.assertNotNull((Object)removedVersion);
        Assert.assertEquals((Object)removedVersion.compareTo(oldVersion), (Object)InequalVersionComparisonResult.AFTER);
        this.checkCaches(KEY, null);
        Assert.assertNull((Object)this.cache(1).remove((Object)KEY));
        entry = this.dc(0).peek((Object)KEY);
        AssertJUnit.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        AssertJUnit.assertNotNull((Object)entry.getMetadata());
        EntryVersion secondRemovedVersion = entry.getMetadata().version();
        AssertJUnit.assertNotNull((Object)removedVersion);
        Assert.assertEquals((Object)secondRemovedVersion.compareTo(removedVersion), (Object)InequalVersionComparisonResult.AFTER);
        this.flush(true);
        for (Cache c : this.caches()) {
            Assert.assertFalse((boolean)c.getAdvancedCache().getDataContainer().containsKey((Object)KEY));
        }
    }

    public void testConditionalReplace() {
        MagicKey KEY = new MagicKey(this.cache(0));
        this.cache(0).put((Object)KEY, (Object)VALUE1);
        Assert.assertTrue((boolean)this.cache(0).replace((Object)KEY, (Object)VALUE1, (Object)VALUE2));
        Assert.assertFalse((boolean)this.cache(0).replace((Object)KEY, (Object)VALUE1, (Object)VALUE3));
        Assert.assertTrue((boolean)this.cache(1).replace((Object)KEY, (Object)VALUE2, (Object)VALUE3));
        Assert.assertFalse((boolean)this.cache(1).replace((Object)KEY, (Object)VALUE2, (Object)VALUE1));
        Assert.assertTrue((boolean)this.cache(2).replace((Object)KEY, (Object)VALUE3, (Object)VALUE1));
        Assert.assertFalse((boolean)this.cache(2).replace((Object)KEY, (Object)VALUE3, (Object)VALUE2));
    }

    public void testPutAll() {
        HashMap<MagicKey, String> data = new HashMap<MagicKey, String>();
        MagicKey KEY1 = new MagicKey(this.cache(0));
        MagicKey KEY2 = new MagicKey(this.cache(1));
        MagicKey KEY3 = new MagicKey(this.cache(2));
        data.put(KEY1, VALUE1);
        data.put(KEY2, VALUE2);
        data.put(KEY3, VALUE3);
        this.cache(0).putAll(data);
        Assert.assertTrue((boolean)this.dc(0).containsKey((Object)KEY1));
        Assert.assertTrue((boolean)this.dc(0).containsKey((Object)KEY2));
        Assert.assertTrue((boolean)this.dc(0).containsKey((Object)KEY3));
        Assert.assertTrue((boolean)this.dc(1).containsKey((Object)KEY1));
        Assert.assertTrue((boolean)this.dc(1).containsKey((Object)KEY2));
        Assert.assertFalse((boolean)this.dc(1).containsKey((Object)KEY3));
        Assert.assertFalse((boolean)this.dc(2).containsKey((Object)KEY1));
        Assert.assertFalse((boolean)this.dc(2).containsKey((Object)KEY2));
        Assert.assertTrue((boolean)this.dc(2).containsKey((Object)KEY3));
    }

    public void testGetAll() {
        MagicKey KEY1 = new MagicKey(this.cache(0));
        MagicKey KEY2 = new MagicKey(this.cache(1));
        MagicKey KEY3 = new MagicKey(this.cache(2));
        HashSet<MagicKey> keys = new HashSet<MagicKey>(Arrays.asList(KEY1, KEY2, KEY3));
        this.cache(0).put((Object)KEY1, (Object)VALUE1);
        this.cache(1).put((Object)KEY2, (Object)VALUE2);
        this.cache(2).put((Object)KEY3, (Object)VALUE3);
        for (Cache c : this.caches()) {
            Map map = c.getAdvancedCache().getAll(keys);
            Assert.assertEquals(map.get(KEY1), (Object)VALUE1);
            Assert.assertEquals(map.get(KEY2), (Object)VALUE2);
            Assert.assertEquals(map.get(KEY3), (Object)VALUE3);
            Assert.assertEquals((int)map.size(), (int)3);
        }
    }
}

