/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scattered.ControlledScatteredVersionManager;
import org.infinispan.scattered.ScatteredVersionManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;

public abstract class BaseScatteredTest
extends MultipleCacheManagersTest {
    protected EmbeddedCacheManager cm1;
    protected EmbeddedCacheManager cm2;
    protected EmbeddedCacheManager cm3;
    protected ControlledScatteredVersionManager[] svms;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = BaseScatteredTest.getDefaultClusteredCacheConfig(CacheMode.SCATTERED_SYNC, false);
        if (this.biasAcquisition != null) {
            cfg.clustering().biasAcquisition(this.biasAcquisition);
        }
        cfg.clustering().hash().numSegments(16);
        cfg.clustering().remoteTimeout(4L, TimeUnit.MINUTES);
        this.createCluster(TestDataSCI.INSTANCE, cfg, 3);
        this.cm1 = this.manager(0);
        this.cm2 = this.manager(1);
        this.cm3 = this.manager(2);
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            cm.getCache();
        }
        TestingUtil.waitForNoRebalance(this.caches());
        this.svms = (ControlledScatteredVersionManager[])this.caches().stream().map(c -> {
            ControlledScatteredVersionManager csvm = new ControlledScatteredVersionManager();
            BasicComponentRegistry bcr = (BasicComponentRegistry)c.getAdvancedCache().getComponentRegistry().getComponent(BasicComponentRegistry.class);
            bcr.replaceComponent(ScatteredVersionManager.class.getName(), csvm, true);
            bcr.rewire();
            return csvm;
        }).toArray(ControlledScatteredVersionManager[]::new);
    }

    protected ControlledScatteredVersionManager svm(int node) {
        return this.svms[node];
    }

    protected void flush(boolean expectRemoval) {
        ControlledScatteredVersionManager.flush(expectRemoval, this.svms);
    }

    protected DataContainer<Object, Object> dc(int index) {
        return this.cache(index).getAdvancedCache().getDataContainer();
    }
}

