/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.RenewBiasCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ExceptionAckCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.scattered.BiasManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.CountingRpcManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scattered.BiasLeaseTest")
public class BiasLeaseTest
extends MultipleCacheManagersTest {
    private static final long BIAS_LIFESPAN = (Long)ClusteringConfiguration.BIAS_LIFESPAN.getDefaultValue();
    private ControlledRpcManager rpcManager0;
    private CountingRpcManager rpcManager1;
    private ControlledTimeService timeService = new ControlledTimeService();
    private RenewWaitingInvocationHandler handler0;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = BiasLeaseTest.getDefaultClusteredCacheConfig(CacheMode.SCATTERED_SYNC, false);
        builder.clustering().biasAcquisition(BiasAcquisition.ON_WRITE);
        builder.expiration().wakeUpInterval(100L);
        this.createCluster(TestDataSCI.INSTANCE, builder, 3);
        this.waitForClusterToForm();
        Arrays.stream(this.managers()).forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true));
        this.rpcManager0 = ControlledRpcManager.replaceRpcManager(this.cache(0));
        this.rpcManager1 = CountingRpcManager.replaceRpcManager(this.cache(1));
        TestingUtil.wrapInboundInvocationHandler(this.cache(0), handler -> {
            this.handler0 = new RenewWaitingInvocationHandler((PerCacheInboundInvocationHandler)handler);
            return this.handler0;
        });
    }

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        this.rpcManager0.excludeCommands(ClearCommand.class);
        IntStream.of(0, 1, 2).mapToObj(this::cache).forEach(Cache::clear);
        this.rpcManager0.excludeCommands(new Class[0]);
    }

    public void testBiasTimesOut() throws Exception {
        this.rpcManager0.excludeCommands(ExceptionAckCommand.class);
        MagicKey key = new MagicKey(this.cache(0));
        this.cache(1).put((Object)key, (Object)"v0");
        AssertJUnit.assertTrue((boolean)this.biasManager(1).hasLocalBias((Object)key));
        this.timeService.advance(BIAS_LIFESPAN + 1L);
        this.rpcManager0.expectCommand(RevokeBiasCommand.class).send().receiveAll();
        AssertJUnit.assertFalse((boolean)this.biasManager(1).hasLocalBias((Object)key));
        this.eventuallyEquals(null, () -> this.biasManager(0).getRemoteBias((Object)key));
    }

    public void testBiasLeaseRenewed() throws Exception {
        MagicKey key = new MagicKey(this.cache(0));
        this.rpcManager0.excludeCommands(ExceptionAckCommand.class);
        this.cache(1).put((Object)key, (Object)"v0");
        AssertJUnit.assertEquals(Collections.singletonList(this.address(1)), (Object)this.biasManager(0).getRemoteBias((Object)key));
        AssertJUnit.assertTrue((boolean)this.biasManager(1).hasLocalBias((Object)key));
        for (int i = 0; i < 3; ++i) {
            CountDownLatch latch = new CountDownLatch(1);
            this.handler0.latch = latch;
            this.timeService.advance(BIAS_LIFESPAN - 1L);
            this.rpcManager1.resetStats();
            AssertJUnit.assertEquals((Object)"v0", (Object)this.cache(1).get((Object)key));
            AssertJUnit.assertEquals((int)0, (int)this.rpcManager1.clusterGet);
            AssertJUnit.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
            AssertJUnit.assertEquals(Collections.singletonList(this.address(1)), (Object)this.biasManager(0).getRemoteBias((Object)key));
        }
    }

    protected BiasManager biasManager(int index) {
        return (BiasManager)this.cache(index).getAdvancedCache().getComponentRegistry().getComponent(BiasManager.class);
    }

    private class RenewWaitingInvocationHandler
    extends AbstractDelegatingHandler {
        private volatile CountDownLatch latch;

        private RenewWaitingInvocationHandler(PerCacheInboundInvocationHandler delegate) {
            super(delegate);
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            CountDownLatch latch = this.latch;
            if (command instanceof RenewBiasCommand && latch != null) {
                this.delegate.handle(command, response -> {
                    reply.reply(response);
                    this.latch = null;
                    latch.countDown();
                }, order);
            } else {
                this.delegate.handle(command, reply, order);
            }
        }
    }
}

