/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.scattered.BiasManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.AbstractDelegatingRpcManager;
import org.infinispan.util.CountingRpcManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scattered.BiasRevocationTest")
public class BiasRevocationTest
extends MultipleCacheManagersTest {
    private FailingRpcManager rpcManager0;
    private CountingRpcManager rpcManager2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = BiasRevocationTest.getDefaultClusteredCacheConfig(CacheMode.SCATTERED_SYNC, false);
        builder.clustering().biasAcquisition(BiasAcquisition.ON_WRITE).remoteTimeout(1000L);
        this.createCluster(TestDataSCI.INSTANCE, builder, 3);
        TestingUtil.wrapComponent(this.cache(0), RpcManager.class, rpcManager -> {
            this.rpcManager0 = new FailingRpcManager((RpcManager)rpcManager);
            return this.rpcManager0;
        });
        this.cache(1);
        TestingUtil.wrapComponent(this.cache(2), RpcManager.class, rpcManager -> {
            this.rpcManager2 = new CountingRpcManager((RpcManager)rpcManager);
            return this.rpcManager2;
        });
    }

    protected static void put(Cache cache, Object key, Object value) {
        cache.put(key, value);
    }

    protected static void putAll(Cache cache, Object key, Object value) {
        cache.putAll(Collections.singletonMap(key, value));
    }

    public void testFailedRevocationDuringPutOnPrimaryThrowBefore() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwBefore = !this.rpcManager0.throwBefore;
        }, BiasRevocationTest::put, true);
    }

    public void testFailedRevocationDuringPutOnPrimaryThrowInFuture() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwInFuture = !this.rpcManager0.throwInFuture;
        }, BiasRevocationTest::put, true);
    }

    public void testFailedRevocationDuringPutAllOnPrimaryThrowBefore() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwBefore = !this.rpcManager0.throwBefore;
        }, BiasRevocationTest::putAll, true);
    }

    public void testFailedRevocationDuringPutAllOnPrimaryThrowInFuture() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwInFuture = !this.rpcManager0.throwInFuture;
        }, BiasRevocationTest::putAll, true);
    }

    public void testFailedRevocationDuringPutOnNonOwnerThrowBefore() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwBefore = !this.rpcManager0.throwBefore;
        }, BiasRevocationTest::put, false);
    }

    public void testFailedRevocationDuringPutOnNonOwnerThrowInFuture() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwInFuture = !this.rpcManager0.throwInFuture;
        }, BiasRevocationTest::put, false);
    }

    public void testFailedRevocationDuringPutAllOnNonOwnerThrowBefore() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwBefore = !this.rpcManager0.throwBefore;
        }, BiasRevocationTest::putAll, false);
    }

    public void testFailedRevocationDuringPutAllOnNonOwnerThrowInFuture() {
        this.testFailedRevocation(() -> {
            this.rpcManager0.throwInFuture = !this.rpcManager0.throwInFuture;
        }, BiasRevocationTest::putAll, false);
    }

    protected void testFailedRevocation(Runnable switchFailure, Operation operation, boolean primary) {
        MagicKey key = new MagicKey(this.cache(0));
        this.cache(2).put((Object)key, (Object)"v0");
        AssertJUnit.assertTrue((boolean)this.biasManager(2).hasLocalBias((Object)key));
        AssertJUnit.assertEquals(Collections.singletonList(this.address(2)), (Object)this.biasManager(0).getRemoteBias((Object)key));
        this.rpcManager2.resetStats();
        AssertJUnit.assertEquals((Object)"v0", (Object)this.cache(2).get((Object)key));
        AssertJUnit.assertEquals((int)0, (int)this.rpcManager2.clusterGet);
        AssertJUnit.assertEquals((int)0, (int)this.rpcManager2.otherCount);
        switchFailure.run();
        if (primary) {
            Exceptions.expectException(RemoteException.class, () -> operation.apply(this.cache(0), key, "v1"));
        } else {
            Exceptions.expectException(TimeoutException.class, () -> operation.apply(this.cache(1), key, "v1"));
        }
        AssertJUnit.assertTrue((boolean)this.biasManager(2).hasLocalBias((Object)key));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(0).get((Object)key));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(1).get((Object)key));
        AssertJUnit.assertEquals((Object)"v0", (Object)this.cache(2).get((Object)key));
        switchFailure.run();
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(1).put((Object)key, (Object)"v2"));
        AssertJUnit.assertFalse((boolean)this.biasManager(2).hasLocalBias((Object)key));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(2).get((Object)key));
    }

    @AfterMethod
    public void resetFailures() {
        this.rpcManager0.throwBefore = false;
        this.rpcManager0.throwInFuture = false;
        this.caches().forEach(Cache::clear);
    }

    protected BiasManager biasManager(int index) {
        return (BiasManager)this.cache(index).getAdvancedCache().getComponentRegistry().getComponent(BiasManager.class);
    }

    private class FailingRpcManager
    extends AbstractDelegatingRpcManager {
        public boolean throwBefore;
        public boolean throwInFuture;

        public FailingRpcManager(RpcManager realOne) {
            super(realOne);
            this.throwBefore = false;
            this.throwInFuture = false;
        }

        @Override
        protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker, RpcOptions rpcOptions) {
            if (command instanceof RevokeBiasCommand) {
                if (this.throwBefore) {
                    throw new RemoteException("Induced", null);
                }
                if (this.throwInFuture) {
                    return CompletableFutures.completedExceptionFuture((Throwable)new RemoteException("Induced", null));
                }
            }
            return super.performRequest(targets, command, collector, invoker, rpcOptions);
        }
    }

    private static interface Operation {
        public void apply(Cache var1, Object var2, Object var3);
    }
}

