/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.io.Serializable;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.DistSyncFuncTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.scattered.Utils;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scattered.ScatteredSyncFuncTest")
public class ScatteredSyncFuncTest
extends DistSyncFuncTest {
    @Override
    public Object[] factory() {
        return new Object[]{new ScatteredSyncFuncTest().biasAcquisition(BiasAcquisition.NEVER), new ScatteredSyncFuncTest().biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    public ScatteredSyncFuncTest() {
        this.cacheMode = CacheMode.SCATTERED_SYNC;
        this.numOwners = 1;
        this.l1CacheEnabled = false;
    }

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = super.buildConfiguration();
        builder.clustering().biasAcquisition(this.biasAcquisition);
        return builder;
    }

    @Override
    protected void assertOwnershipAndNonOwnership(Object key, boolean allowL1) {
        Utils.assertOwnershipAndNonOwnership(this.caches, key);
    }

    public void testCompute() {
        MagicKey key = new MagicKey(this.cache(0, this.cacheName));
        this.cache(1, this.cacheName).put((Object)key, (Object)"a");
        AssertJUnit.assertEquals((Object)"ab", (Object)this.cache(2, this.cacheName).compute((Object)key, (SerializableBiFunction & Serializable)(k, v) -> v + "b"));
        this.assertLocalValue(0, key, "ab");
        this.assertLocalValue(1, key, "a");
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"abc", (Object)this.cache(0, this.cacheName).compute((Object)key, (SerializableBiFunction & Serializable)(k, v) -> v + "c"));
        this.assertLocalValue(0, key, "abc");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals(null, (Object)this.cache(1, this.cacheName).compute((Object)key, (SerializableBiFunction & Serializable)(k, v) -> "abc".equals(v) ? null : "unexpected"));
        this.assertLocalValue(0, key, null);
        this.assertLocalValue(1, key, null);
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        MagicKey otherKey = new MagicKey(this.cache(0, this.cacheName));
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(1, this.cacheName).compute((Object)otherKey, (SerializableBiFunction & Serializable)(k, v) -> v == null ? "x" : "unexpected"));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(otherKey, false);
        AssertJUnit.assertEquals(null, (Object)this.cache(0, this.cacheName).compute((Object)otherKey, (SerializableBiFunction & Serializable)(k, v) -> "x".equals(v) ? null : "unexpected"));
        this.assertLocalValue(0, otherKey, null);
        this.assertOwnershipAndNonOwnership(otherKey, false);
        AssertJUnit.assertEquals((Object)"y", (Object)this.cache(0, this.cacheName).compute((Object)otherKey, (SerializableBiFunction & Serializable)(k, v) -> v == null ? "y" : "unexpected"));
        this.assertLocalValue(0, otherKey, "y");
        this.assertOwnershipAndNonOwnership(otherKey, false);
    }

    public void testComputeIfPresent() {
        MagicKey key = new MagicKey(this.cache(0, this.cacheName));
        this.cache(1, this.cacheName).put((Object)key, (Object)"a");
        AssertJUnit.assertEquals((Object)"ab", (Object)this.cache(2, this.cacheName).computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> v + "b"));
        this.assertLocalValue(0, key, "ab");
        this.assertLocalValue(1, key, "a");
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"abc", (Object)this.cache(0, this.cacheName).computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> v + "c"));
        this.assertLocalValue(0, key, "abc");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals(null, (Object)this.cache(1, this.cacheName).computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> "abc".equals(v) ? null : "unexpected"));
        this.assertLocalValue(0, key, null);
        this.assertLocalValue(1, key, null);
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals(null, (Object)this.cache(0, this.cacheName).computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> "unexpected"));
        this.assertLocalValue(0, key, null);
        this.assertLocalValue(1, key, null);
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        MagicKey otherKey = new MagicKey(this.cache(0, this.cacheName));
        AssertJUnit.assertEquals(null, (Object)this.cache(1, this.cacheName).computeIfPresent((Object)otherKey, (SerializableBiFunction & Serializable)(k, v) -> "unexpected"));
        this.assertNoLocalValue(0, otherKey);
        this.assertNoLocalValue(1, otherKey);
        this.assertNoLocalValue(2, otherKey);
    }

    public void testComputeIfAbsent() {
        MagicKey key = new MagicKey(this.cache(0, this.cacheName));
        this.cache(1, this.cacheName).put((Object)key, (Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(2, this.cacheName).computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> "b"));
        this.assertLocalValue(0, key, "a");
        this.assertLocalValue(1, key, "a");
        this.assertNoLocalValue(2, key);
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(2, this.cacheName).get((Object)key));
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(1, this.cacheName).computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> "c"));
        this.assertLocalValue(0, key, "a");
        this.assertLocalValue(1, key, "a");
        this.assertNoLocalValue(2, key);
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(2, this.cacheName).get((Object)key));
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(2, this.cacheName).computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> "d"));
        this.assertLocalValue(0, key, "a");
        this.assertLocalValue(1, key, "a");
        this.assertNoLocalValue(2, key);
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(2, this.cacheName).get((Object)key));
        this.assertOwnershipAndNonOwnership(key, false);
        MagicKey otherKey = new MagicKey(this.cache(0, this.cacheName));
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(1, this.cacheName).computeIfAbsent((Object)otherKey, (SerializableFunction & Serializable)k -> "x"));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(2, this.cacheName).computeIfAbsent((Object)otherKey, (SerializableFunction & Serializable)k -> "y"));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(0, this.cacheName).computeIfAbsent((Object)otherKey, (SerializableFunction & Serializable)k -> null));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(1, this.cacheName).computeIfAbsent((Object)otherKey, (SerializableFunction & Serializable)k -> null));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(2, this.cacheName).computeIfAbsent((Object)otherKey, (SerializableFunction & Serializable)k -> null));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(key, false);
    }

    public void testMerge() {
        MagicKey key = new MagicKey(this.cache(0, this.cacheName));
        this.cache(1, this.cacheName).put((Object)key, (Object)"a");
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.cache(2, this.cacheName).merge((Object)key, (Object)"b", (SerializableBiFunction & Serializable)(o, n) -> o + n)));
        this.assertLocalValue(0, key, "ab");
        this.assertLocalValue(1, key, "a");
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals((String)"abc", (String)((String)this.cache(0, this.cacheName).merge((Object)key, (Object)"c", (SerializableBiFunction & Serializable)(o, n) -> o + n)));
        this.assertLocalValue(0, key, "abc");
        this.assertOwnershipAndNonOwnership(key, false);
        AssertJUnit.assertEquals(null, (Object)this.cache(1, this.cacheName).merge((Object)key, (Object)"x", (SerializableBiFunction & Serializable)(o, n) -> "abc".equals(o) ? null : "unexpected"));
        this.assertLocalValue(0, key, null);
        this.assertLocalValue(1, key, null);
        this.assertLocalValue(2, key, "ab");
        this.assertOwnershipAndNonOwnership(key, false);
        MagicKey otherKey = new MagicKey(this.cache(0, this.cacheName));
        AssertJUnit.assertEquals((Object)"x", (Object)this.cache(1, this.cacheName).merge((Object)otherKey, (Object)"x", (SerializableBiFunction & Serializable)(o, n) -> "unexpected"));
        this.assertLocalValue(0, otherKey, "x");
        this.assertLocalValue(1, otherKey, "x");
        this.assertNoLocalValue(2, otherKey);
        this.assertOwnershipAndNonOwnership(otherKey, false);
        AssertJUnit.assertEquals(null, (Object)this.cache(0, this.cacheName).merge((Object)otherKey, (Object)"y", (SerializableBiFunction & Serializable)(o, n) -> "x".equals(o) ? null : "unexpected"));
        this.assertLocalValue(0, otherKey, null);
        this.assertOwnershipAndNonOwnership(otherKey, false);
        AssertJUnit.assertEquals((Object)"z", (Object)this.cache(0, this.cacheName).merge((Object)otherKey, (Object)"z", (SerializableBiFunction & Serializable)(o, n) -> "unexpected"));
        this.assertLocalValue(0, otherKey, "z");
        this.assertOwnershipAndNonOwnership(otherKey, false);
    }

    protected void assertNoLocalValue(int node, MagicKey key) {
        InternalCacheEntry ice = this.cache(node, this.cacheName).getAdvancedCache().getDataContainer().get((Object)key);
        AssertJUnit.assertEquals(null, (Object)ice);
    }

    protected void assertLocalValue(int node, MagicKey key, String expectedValue) {
        InternalCacheEntry ice = this.cache(node, this.cacheName).getAdvancedCache().getDataContainer().get((Object)key);
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((Object)expectedValue, (Object)ice.getValue());
    }
}

