/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;

public class Utils {
    public static void assertOwnershipAndNonOwnership(List<? extends Cache> caches, Object key) {
        EntryVersion ownerVersion = null;
        for (Cache cache : caches) {
            DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
            InternalCacheEntry ice = dataContainer.peek(key);
            if (!DistributionTestHelper.isOwner(cache, key)) continue;
            assert (ice != null) : "Fail on owner cache " + DistributionTestHelper.addressOf(cache) + ": dc.get(" + key + ") returned null!";
            assert (ice instanceof ImmortalCacheEntry) : "Fail on owner cache " + DistributionTestHelper.addressOf(cache) + ": dc.get(" + key + ") returned " + DistributionTestHelper.safeType(ice);
            ownerVersion = ice.getMetadata().version();
        }
        Assert.assertNotNull(ownerVersion);
        if (caches.size() == 1) {
            return;
        }
        int equalVersions = 0;
        for (Cache cache : caches) {
            DataContainer dc = cache.getAdvancedCache().getDataContainer();
            InternalCacheEntry ice = dc.peek(key);
            if (DistributionTestHelper.isOwner(cache, key) || ice == null || ice == null || ice.getMetadata() == null || !ownerVersion.equals(ice.getMetadata().version())) continue;
            ++equalVersions;
        }
        Assert.assertEquals((int)equalVersions, (int)1);
    }

    public static void assertInStores(List<? extends Cache> caches, String key, String value) {
        EntryVersion ownerVersion = null;
        for (Cache cache : caches) {
            DummyInMemoryStore dummyInMemoryStore = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
            if (!DistributionTestHelper.isOwner(cache, key)) continue;
            DistributionTestHelper.assertIsInContainerImmortal(cache, key);
            MarshallableEntry me = dummyInMemoryStore.loadEntry(key);
            Assert.assertEquals((Object)me.getValue(), (Object)value);
            ownerVersion = me.getMetadata().version();
        }
        Assert.assertNotNull(ownerVersion);
        if (caches.size() == 1) {
            return;
        }
        int equalVersions = 0;
        for (Cache cache : caches) {
            MarshallableEntry me;
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
            if (DistributionTestHelper.isOwner(cache, key) || (me = store.loadEntry(key)) == null || me.getMetadata() == null || !ownerVersion.equals(me.getMetadata().version())) continue;
            Assert.assertEquals((Object)me.getValue(), (Object)value);
            ++equalVersions;
        }
        Assert.assertEquals((int)equalVersions, (int)1);
    }
}

