/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.statetransfer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.Assert;

public abstract class AbstractStateTransferTest
extends MultipleCacheManagersTest {
    protected static final String CACHE_NAME = "scattered";
    protected static final TransportFlags TRANSPORT_FLAGS = new TransportFlags().withFD(true).withMerge(true);
    protected ConfigurationBuilder defaultConfig;
    protected Cache<Object, Object> c1;
    protected Cache<Object, Object> c2;
    protected Cache<Object, Object> c3;

    protected List<MagicKey> init() {
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>();
        int numCaches = this.caches(CACHE_NAME).size();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            MagicKey key = new MagicKey("key" + i, this.cache(i % numCaches, CACHE_NAME));
            this.cache(random.nextInt(numCaches), CACHE_NAME).put((Object)key, (Object)("value" + i));
            keys.add(key);
        }
        return keys;
    }

    protected void checkValuesInDC(List<MagicKey> keys, Cache ... caches) {
        assert (caches != null && caches.length > 0);
        for (Cache c : caches) {
            for (int i = 0; i < keys.size(); ++i) {
                this.assertHasValueInDC(c, keys.get(i), "value" + i);
            }
        }
    }

    protected void checkValuesInCache(List<MagicKey> keys, Cache ... caches) {
        assert (caches != null && caches.length > 0);
        for (Cache c : caches) {
            for (int i = 0; i < keys.size(); ++i) {
                Assert.assertEquals((Object)c.get((Object)keys.get(i)), (Object)("value" + i));
            }
        }
    }

    private void assertHasValueInDC(Cache c, Object key, Object value) {
        InternalCacheEntry entry = c.getAdvancedCache().getDataContainer().peek(key);
        Assert.assertNotNull((Object)entry, (String)("Missing " + key));
        Assert.assertEquals((Object)entry.getValue(), (Object)value, (String)("Incorrect value for key " + key));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.defaultConfig = AbstractStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.SCATTERED_SYNC, false);
        this.defaultConfig.clustering().hash().numSegments(16);
        this.defaultConfig.clustering().biasAcquisition(this.biasAcquisition);
        this.defaultConfig.clustering().stateTransfer().fetchInMemoryState(true).chunkSize(3);
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, this.defaultConfig, TRANSPORT_FLAGS, CACHE_NAME);
        this.c1 = this.cache(0, CACHE_NAME);
        this.c2 = this.cache(1, CACHE_NAME);
        this.c3 = this.cache(2, CACHE_NAME);
    }
}

