/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.statetransfer;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scattered.statetransfer.AbstractStateTransferTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.jgroups.protocols.DISCARD;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scattered.statetransfer.CrashJoinTest")
@CleanupAfterMethod
public class CrashJoinTest
extends AbstractStateTransferTest {
    private DISCARD d1;
    private DISCARD d2;
    private DISCARD d3;

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.d1 = TestingUtil.getDiscardForCache(this.c1.getCacheManager());
        this.d2 = TestingUtil.getDiscardForCache(this.c2.getCacheManager());
        this.d3 = TestingUtil.getDiscardForCache(this.c3.getCacheManager());
    }

    public void testNodeCrash() {
        List<MagicKey> keys = this.init();
        AssertJUnit.assertFalse((boolean)this.c2.getCacheManager().isCoordinator());
        this.d2.setDiscardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1, this.c3);
        TestingUtil.waitForNoRebalance(this.c1, this.c3);
        this.checkValuesInDC(keys, this.c1, this.c3);
    }

    public void testCoordCrash() {
        List<MagicKey> keys = this.init();
        AssertJUnit.assertTrue((boolean)this.c1.getCacheManager().isCoordinator());
        this.d1.setDiscardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c2, this.c3);
        TestingUtil.waitForNoRebalance(this.c2, this.c3);
        this.checkValuesInDC(keys, this.c2, this.c3);
    }

    public void testNodeJoin() throws Exception {
        List<MagicKey> keys = this.init();
        EmbeddedCacheManager cm4 = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, null, TRANSPORT_FLAGS);
        Cache c4 = cm4.createCache("scattered", this.defaultConfig.build());
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1, this.c2, this.c3, c4);
        TestingUtil.waitForNoRebalance(this.c1, this.c2, this.c3, c4);
        this.checkValuesInCache(keys, this.c1, this.c2, this.c3, c4);
    }
}

