/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.stream;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.statetransfer.ScatteredStateGetKeysCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.stream.DistributedStreamIteratorTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="iteration.ScatteredStreamIteratorTest")
public class ScatteredStreamIteratorTest
extends DistributedStreamIteratorTest {
    public ScatteredStreamIteratorTest() {
        super(false, CacheMode.SCATTERED_SYNC);
    }

    @Override
    public void testNodeLeavesWhileIteratingOverContainerCausingRehashToLoseValues() {
    }

    @Override
    public void waitUntilProcessingResults() {
    }

    @Override
    protected <K> void blockStateTransfer(Cache<?, ?> cache, final CheckPoint checkPoint) {
        final Executor executor = TestingUtil.extractGlobalComponent((CacheContainer)cache.getCacheManager(), ExecutorService.class, "org.infinispan.executors.non-blocking");
        TestingUtil.wrapInboundInvocationHandler(cache, handler -> new AbstractDelegatingHandler((PerCacheInboundInvocationHandler)handler){

            public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
                if (!(command instanceof ScatteredStateGetKeysCommand)) {
                    this.delegate.handle(command, reply, order);
                    return;
                }
                checkPoint.trigger("before_invocation");
                ((CompletableFuture)checkPoint.future("before_release", 2L, TimeUnit.SECONDS, executor).whenComplete((ignored1, ignored2) -> this.delegate.handle(command, reply, order))).thenCompose(ignored -> {
                    checkPoint.trigger("after_invocation");
                    return checkPoint.future("after_release", 20L, TimeUnit.SECONDS, executor);
                });
            }
        });
    }
}

