/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.lang.reflect.Field;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.BaseAuthorizationTest;
import org.infinispan.security.Security;
import org.infinispan.security.TestCachePermission;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="security.CacheManagerAuthorizationTest")
public class CacheManagerAuthorizationTest
extends BaseAuthorizationTest {
    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    Runnable GET_GLOBAL_COMPONENT_REGISTRY = () -> this.cacheManager.getGlobalComponentRegistry();
    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    Runnable GET_CACHE_MANAGER_CONFIGURATION = () -> this.cacheManager.getCacheManagerConfiguration();
    @TestCachePermission(value=AuthorizationPermission.MONITOR)
    Runnable GET_STATS = () -> this.cacheManager.getStats();

    public void testCombinations() throws Exception {
        Field[] fields;
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            if (!f.getType().equals(Runnable.class)) continue;
            Runnable fn = (Runnable)f.get(this);
            PrivilegedExceptionAction<Boolean> action = () -> {
                fn.run();
                return true;
            };
            TestCachePermission p = f.getAnnotation(TestCachePermission.class);
            for (AuthorizationPermission perm : AuthorizationPermission.values()) {
                Subject subject = (Subject)SUBJECTS.get(perm);
                if (perm.implies(p.value())) {
                    Assert.assertTrue((boolean)((Boolean)Security.doAs((Subject)subject, action)));
                    continue;
                }
                Exceptions.expectException(PrivilegedActionException.class, SecurityException.class, () -> Security.doAs((Subject)subject, (PrivilegedExceptionAction)action));
            }
        }
    }
}

