/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.ClusterRoleMapperTest")
public class ClusterRoleMapperTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    static final Subject SUBJECT_A = TestingUtil.makeSubject("A");
    static final Subject SUBJECT_B = TestingUtil.makeSubject("B");
    private ClusterRoleMapper cpm;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new ClusterRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("reader").permission(AuthorizationPermission.ALL_READ).role("writer").permission(AuthorizationPermission.ALL_WRITE).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("reader").role("writer").role("admin");
        return TestCacheManagerFactory.createCacheManager(global, config);
    }

    @Override
    protected void setup() throws Exception {
        this.cpm = (ClusterRoleMapper)Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<ClusterRoleMapper>(){

            @Override
            public ClusterRoleMapper run() throws Exception {
                ClusterRoleMapperTest.this.cacheManager = ClusterRoleMapperTest.this.createCacheManager();
                ClusterRoleMapperTest.this.cpm = (ClusterRoleMapper)ClusterRoleMapperTest.this.cacheManager.getCacheManagerConfiguration().security().authorization().principalRoleMapper();
                ClusterRoleMapperTest.this.cpm.grant("admin", "admin");
                ClusterRoleMapperTest.this.cache = ClusterRoleMapperTest.this.cacheManager.getCache();
                return ClusterRoleMapperTest.this.cpm;
            }
        });
    }

    public void testClusterPrincipalMapper() {
        this.cpm.grant("writer", "A");
        Security.doAs((Subject)SUBJECT_A, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ClusterRoleMapperTest.this.cacheManager.getCache().put((Object)"key", (Object)"value");
                return null;
            }
        });
        this.cpm.grant("reader", "B");
        Security.doAs((Subject)SUBJECT_B, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AssertJUnit.assertEquals((Object)"value", (Object)ClusterRoleMapperTest.this.cacheManager.getCache().get((Object)"key"));
                return null;
            }
        });
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ClusterRoleMapperTest.super.teardown();
                return null;
            }
        });
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ClusterRoleMapperTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }
}

