/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.ClusteredSecureCacheTest")
public class ClusteredSecureCacheTest
extends MultipleCacheManagersTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");

    public CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ConfigurationBuilder builder = ClusteredSecureCacheTest.getDefaultClusteredCacheConfig(this.getCacheMode());
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL);
        builder.security().authorization().enable().role("admin");
        Security.doAs((Subject)ADMIN, () -> {
            this.createCluster(global, builder, 2);
            this.waitForClusterToForm();
            return null;
        });
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Security.doAs((Subject)ADMIN, () -> {
            ClusteredSecureCacheTest.super.destroy();
            return null;
        });
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        Security.doAs((Subject)ADMIN, () -> {
            try {
                ClusteredSecureCacheTest.super.clearContent();
            }
            catch (Throwable e) {
                throw new Exception(e);
            }
            return null;
        });
    }

    public void testClusteredSecureCache() {
        Security.doAs((Subject)ADMIN, () -> {
            Cache cache1 = this.cache(0);
            Cache cache2 = this.cache(1);
            cache1.put((Object)"a", (Object)"a");
            cache2.put((Object)"b", (Object)"b");
            AssertJUnit.assertEquals((String)"a", (String)((String)cache2.get((Object)"a")));
            AssertJUnit.assertEquals((String)"b", (String)((String)cache1.get((Object)"b")));
            return null;
        });
    }
}

