/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.RolePermissionTest")
public class RolePermissionTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    static final Subject SUBJECT_A = TestingUtil.makeSubject("A", "role1");
    static final Subject SUBJECT_WITHOUT_PRINCIPAL = TestingUtil.makeSubject(new String[0]);
    AuthorizationManager authzManager;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("role1").permission(AuthorizationPermission.EXEC).role("role2").permission(AuthorizationPermission.EXEC).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("role1").role("role2").role("admin");
        return TestCacheManagerFactory.createCacheManager(global, config);
    }

    @Override
    protected void setup() throws Exception {
        this.authzManager = (AuthorizationManager)Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthorizationManager>(){

            @Override
            public AuthorizationManager run() throws Exception {
                RolePermissionTest.this.cacheManager = RolePermissionTest.this.createCacheManager();
                if (RolePermissionTest.this.cache == null) {
                    RolePermissionTest.this.cache = RolePermissionTest.this.cacheManager.getCache();
                }
                return RolePermissionTest.this.cache.getAdvancedCache().getAuthorizationManager();
            }
        });
    }

    public void testPermissionAndRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC, "role1");
            return null;
        });
    }

    public void testPermissionAndNoRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC);
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testWrongPermissionAndNoRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testWrongPermissionAndRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.LISTEN, "role1");
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testPermissionAndWrongRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC, "role2");
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testWrongPermissionAndWrongRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.LISTEN, "role2");
            return null;
        });
    }

    public void testNoPrincipalInSubject() {
        Security.doAs((Subject)SUBJECT_WITHOUT_PRINCIPAL, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.NONE);
            return null;
        });
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> {
            RolePermissionTest.super.teardown();
            return null;
        });
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> {
            this.cacheManager.getCache().clear();
            return null;
        });
    }
}

