/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.conflict.ConflictManagerFactory;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.FooInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.SecureCache;
import org.infinispan.security.TestCachePermission;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;

public class SecureCacheTestDriver {
    private Metadata metadata;
    private NullListener listener;
    private FooInterceptor interceptor = new FooInterceptor();
    private CacheEventConverter<String, String, String> converter;
    private CacheEventFilter<String, String> keyValueFilter = (key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> true;

    public SecureCacheTestDriver() {
        this.converter = (key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> null;
        this.listener = new NullListener();
        this.metadata = new Metadata(){

            public long lifespan() {
                return -1L;
            }

            public long maxIdle() {
                return -1L;
            }

            public EntryVersion version() {
                return null;
            }

            public Metadata.Builder builder() {
                return null;
            }
        };
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testIsEmpty(SecureCache<String, String> cache) {
        cache.isEmpty();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPut_Object_Object(SecureCache<String, String> cache) {
        cache.put((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetVersion(SecureCache<String, String> cache) {
        cache.getVersion();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsentAsync_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putIfAbsent((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPut_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.put((Object)"a", (Object)"a", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testAddInterceptor_CommandInterceptor_int(SecureCache<String, String> cache) {
        cache.getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)this.interceptor, 0);
        cache.getAsyncInterceptorChain().removeInterceptor(0);
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testRemoveListener_Object(SecureCache<String, String> cache) {
        cache.removeListener((Object)this.listener);
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testRemoveListenerAsync_Object(SecureCache<String, String> cache) {
        CompletionStages.join((CompletionStage)cache.removeListenerAsync((Object)this.listener));
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testLock_Collection(SecureCache<String, String> cache) throws IllegalStateException, SystemException, NotSupportedException {
        try {
            cache.getTransactionManager().begin();
            cache.lock(Collections.singleton("a"));
        }
        finally {
            cache.getTransactionManager().rollback();
        }
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_WRITE)
    public void testClear(SecureCache<String, String> cache) {
        cache.clear();
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetName(SecureCache<String, String> cache) {
        cache.getName();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testKeySet(SecureCache<String, String> cache) {
        cache.keySet();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetCacheConfiguration(SecureCache<String, String> cache) {
        cache.getCacheConfiguration();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAsync_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.putAsync((Object)"a", (Object)"a", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.LIFECYCLE, needsSecurityManager=true)
    public void testStop(SecureCache<String, String> cache) {
        cache.stop();
        cache.start();
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddListener_Object_CacheEventFilter_CacheEventConverter(SecureCache<String, String> cache) {
        cache.addListener((Object)this.listener, this.keyValueFilter, this.converter);
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddListenerAsync_Object_CacheEventFilter_CacheEventConverter(SecureCache<String, String> cache) {
        CompletionStages.join((CompletionStage)cache.addListenerAsync((Object)this.listener, this.keyValueFilter, this.converter));
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddFilteredListenerAsync_Object_CacheEventFilter_CacheEventConverter_Set(SecureCache<String, String> cache) {
        CompletionStages.join((CompletionStage)cache.addListenerAsync((Object)this.listener, this.keyValueFilter, this.converter));
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testEntrySet(SecureCache<String, String> cache) {
        cache.entrySet();
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testContainsValue_Object(SecureCache<String, String> cache) {
        try {
            cache.containsValue((Object)"a");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testContainsKey_Object(SecureCache<String, String> cache) {
        cache.containsKey((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testContainsKeyAsync_Object(SecureCache<String, String> cache) {
        cache.containsKeyAsync((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_Object(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", (Object)"b");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", (Object)"b", new EmbeddedMetadata.Builder().build());
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetStatus(SecureCache<String, String> cache) {
        cache.getStatus();
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetAvailability(SecureCache<String, String> cache) {
        cache.getAvailability();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testSetAvailability_AvailabilityMode(SecureCache<String, String> cache) {
        cache.setAvailability(AvailabilityMode.AVAILABLE);
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testGetAsync_Object(SecureCache<String, String> cache) {
        cache.getAsync((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testStartBatch(SecureCache<String, String> cache) {
        cache.startBatch();
        cache.endBatch(false);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", (Object)"b", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testAddInterceptorAfter_CommandInterceptor_Class(SecureCache<String, String> cache) {
        cache.getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)this.interceptor, InvocationContextInterceptor.class);
        cache.getAsyncInterceptorChain().removeInterceptor(((Object)((Object)this.interceptor)).getClass());
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_Object(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", (Object)"b");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testRemove_Object(SecureCache<String, String> cache) {
        cache.remove((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsentAsync_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putIfAbsentAsync((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", (Object)"b", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAsync_Object_Object(SecureCache<String, String> cache) {
        cache.putAsync((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsent_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putIfAbsent((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testHashCode(SecureCache<String, String> cache) {
        cache.hashCode();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPut_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.put((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsent_Object_Object(SecureCache<String, String> cache) {
        cache.putIfAbsent((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testEvict_Object(SecureCache<String, String> cache) {
        cache.evict((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAsync_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putAsync((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testEndBatch_boolean(SecureCache<String, String> cache) {
        cache.startBatch();
        cache.endBatch(false);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithFlags_FlagArray(SecureCache<String, String> cache) {
        cache.withFlags(Flag.IGNORE_RETURN_VALUES);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithFlags_Collection(SecureCache<String, String> cache) {
        cache.withFlags(Collections.singleton(Flag.IGNORE_RETURN_VALUES));
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithFlags_Flag(SecureCache<String, String> cache) {
        cache.withFlags(Flag.IGNORE_RETURN_VALUES);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testNoFlags(SecureCache<String, String> cache) {
        cache.noFlags();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testTouch_Object_boolean(SecureCache<String, String> cache) {
        cache.touch(new Object(), true);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testTouch_Object_int_boolean(SecureCache<String, String> cache) {
        cache.touch(new Object(), 1, true);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testTransform_Function(SecureCache<String, String> cache) {
        cache.transform(Function.identity());
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWith_ClassLoader(SecureCache<String, String> cache) {
        cache.with(this.getClass().getClassLoader());
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testGetBatchContainer(SecureCache<String, String> cache) {
        cache.getBatchContainer();
    }

    @TestCachePermission(value=AuthorizationPermission.MONITOR)
    public void testGetStats(SecureCache<String, String> cache) {
        cache.getStats();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsentAsync_Object_Object(SecureCache<String, String> cache) {
        cache.putIfAbsentAsync((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsentAsync_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.putIfAbsentAsync((Object)"a", (Object)"a", new EmbeddedMetadata.Builder().build());
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAllAsync_Map(SecureCache<String, String> cache) {
        cache.putAllAsync(Collections.singletonMap("a", "a"));
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testSize(SecureCache<String, String> cache) {
        cache.size();
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testSizeAsync(SecureCache<String, String> cache) {
        cache.sizeAsync();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetDataContainer(SecureCache<String, String> cache) {
        cache.getDataContainer();
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testGetCacheEntry_Object(SecureCache<String, String> cache) {
        cache.getCacheEntry((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testGetCacheEntryAsync_Object(SecureCache<String, String> cache) {
        cache.getCacheEntryAsync((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetTransactionManager(SecureCache<String, String> cache) {
        cache.getTransactionManager();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", (Object)"b", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAll_Map_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putAll(Collections.singletonMap("a", "a"), 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutForExternalRead_Object_Object(SecureCache<String, String> cache) {
        cache.putForExternalRead((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutForExternalRead_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putForExternalRead((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutForExternalRead_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putForExternalRead((Object)"a", (Object)"a", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutForExternalRead_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.putForExternalRead((Object)"a", (Object)"a", new EmbeddedMetadata.Builder().lifespan(1L, TimeUnit.SECONDS).build());
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", new EmbeddedMetadata.Builder().build());
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_WRITE)
    public void testClearAsync(SecureCache<String, String> cache) {
        cache.clearAsync();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testRemoveInterceptor_Class(SecureCache<String, String> cache) {
        cache.getAsyncInterceptorChain().removeInterceptor(((Object)((Object)this.interceptor)).getClass());
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", (Object)"b", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAsync_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putAsync((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAll_Map_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putAll(Collections.singletonMap("a", "a"), 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplace_Object_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.replace((Object)"a", (Object)"a", (Object)"b", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.LIFECYCLE)
    public void testStart(SecureCache<String, String> cache) {
        cache.start();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetDistributionManager(SecureCache<String, String> cache) {
        cache.getDistributionManager();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAll_Map(SecureCache<String, String> cache) {
        cache.putAll(Collections.singletonMap("a", "a"));
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testEquals_Object(SecureCache<String, String> cache) {
        cache.equals(cache);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testRemove_Object_Object(SecureCache<String, String> cache) {
        cache.remove((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testLock_ObjectArray(SecureCache<String, String> cache) throws NotSupportedException, SystemException {
        try {
            cache.getTransactionManager().begin();
            cache.lock((Object[])new String[]{"a"});
        }
        finally {
            cache.getTransactionManager().rollback();
        }
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsent_Object_Object_Metadata(SecureCache<String, String> cache) {
        cache.putIfAbsent((Object)"a", (Object)"a", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testRemoveInterceptor_int(SecureCache<String, String> cache) {
        cache.getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)this.interceptor, 0);
        cache.getAsyncInterceptorChain().removeInterceptor(0);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetComponentRegistry(SecureCache<String, String> cache) {
        cache.getComponentRegistry();
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddListener_Object(SecureCache<String, String> cache) {
        cache.addListener((Object)this.listener);
        cache.removeListener((Object)this.listener);
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddListenerAsync_Object(SecureCache<String, String> cache) {
        CompletionStages.join((CompletionStage)cache.addListenerAsync((Object)this.listener));
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetXAResource(SecureCache<String, String> cache) {
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetAuthorizationManager(SecureCache<String, String> cache) {
        cache.getAuthorizationManager();
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testValues(SecureCache<String, String> cache) {
        cache.values();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testRemoveAsync_Object(SecureCache<String, String> cache) {
        cache.removeAsync((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPut_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.put((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutIfAbsent_Object_Object_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putIfAbsent((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetAdvancedCache(SecureCache<String, String> cache) {
        cache.getAdvancedCache();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testReplaceAsync_Object_Object_long_TimeUnit(SecureCache<String, String> cache) {
        cache.replaceAsync((Object)"a", (Object)"a", 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetCacheManager(SecureCache<String, String> cache) {
        cache.getCacheManager();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAllAsync_Map_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putAllAsync(Collections.singletonMap("a", "a"), 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testGetLockManager(SecureCache<String, String> cache) {
        cache.getLockManager();
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testGetListeners(SecureCache<String, String> cache) {
        cache.getListeners();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAllAsync_Map_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.putAllAsync(Collections.singletonMap("a", "a"), 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAllAsync_Map_Metadata(SecureCache<String, String> cache) {
        cache.putAllAsync(Collections.singletonMap("a", "a"), new EmbeddedMetadata.Builder().build());
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testGet_Object(SecureCache<String, String> cache) {
        cache.get((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetClassLoader(SecureCache<String, String> cache) {
        cache.getClassLoader();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetRpcManager(SecureCache<String, String> cache) {
        cache.getRpcManager();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetConflictResolutionManager(SecureCache<String, String> cache) {
        ConflictManagerFactory.get(cache);
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetAsyncInterceptorChain(SecureCache<String, String> cache) {
        cache.getAsyncInterceptorChain();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testRemoveAsync_Object_Object(SecureCache<String, String> cache) {
        cache.removeAsync((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetEvictionManager(SecureCache<String, String> cache) {
        cache.getEvictionManager();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testGetExpirationManager(SecureCache<String, String> cache) {
        cache.getExpirationManager();
    }

    @TestCachePermission(value=AuthorizationPermission.ADMIN)
    public void testAddInterceptorBefore_CommandInterceptor_Class(SecureCache<String, String> cache) {
        cache.getAsyncInterceptorChain().addInterceptorBefore((AsyncInterceptor)this.interceptor, InvocationContextInterceptor.class);
        cache.getAsyncInterceptorChain().removeInterceptor(((Object)((Object)this.interceptor)).getClass());
    }

    @TestCachePermission(value=AuthorizationPermission.READ)
    public void testGetOrDefault_Object_Object(SecureCache<String, String> cache) {
        cache.get((Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testGetGroup_String(SecureCache<String, String> cache) {
        cache.getGroup("someGroup");
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_WRITE)
    public void testRemoveGroup_String(SecureCache<String, String> cache) {
        cache.removeGroup("someGroup");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testPutAll_Map_Metadata(SecureCache<String, String> cache) {
        cache.putAll(Collections.singletonMap("a", "a"), new EmbeddedMetadata.Builder().lifespan(10L, TimeUnit.SECONDS).maxIdle(5L, TimeUnit.SECONDS).build());
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testGetAll_Set(SecureCache<String, String> cache) {
        cache.getAll(Collections.emptySet());
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testGetAllAsync_Set(SecureCache<String, String> cache) {
        cache.getAllAsync(Collections.emptySet());
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_WRITE)
    public void testGetAndPutAll_Map(SecureCache<String, String> cache) {
        cache.getAndPutAll(Collections.emptyMap());
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testGetAllCacheEntries_Set(SecureCache<String, String> cache) {
        cache.getAllCacheEntries(Collections.emptySet());
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_READ)
    public void testCacheEntrySet(SecureCache<String, String> cache) {
        cache.getAdvancedCache().getAllCacheEntries(Collections.emptySet());
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testRemoveLifespanExpired_Object_Object_Long(SecureCache<String, String> cache) {
        cache.getAdvancedCache().removeLifespanExpired((Object)"a", (Object)"a", null);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testRemoveMaxIdleExpired_Object_Object(SecureCache<String, String> cache) {
        cache.getAdvancedCache().removeMaxIdleExpired((Object)"a", (Object)"a");
    }

    @TestCachePermission(value=AuthorizationPermission.LIFECYCLE, needsSecurityManager=true)
    public void testShutdown(SecureCache<String, String> cache) {
        cache.shutdown();
        cache.start();
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddFilteredListener_Object_CacheEventFilter_CacheEventConverter_Set(SecureCache<String, String> cache) {
        cache.addFilteredListener((Object)this.listener, this.keyValueFilter, this.converter, Collections.emptySet());
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithSubject_Subject(SecureCache<String, String> cache) {
    }

    @TestCachePermission(value=AuthorizationPermission.BULK_WRITE)
    public void testLockedStream(SecureCache<String, String> cache) {
        cache.lockedStream();
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testLockAs_Object(SecureCache<String, String> cache) {
        cache.lockAs(new Object());
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithEncoding_Class(SecureCache<String, String> cache) {
        cache.withEncoding(IdentityEncoder.class);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetKeyDataConversion(SecureCache<String, String> cache) {
        cache.getKeyDataConversion();
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testGetValueDataConversion(SecureCache<String, String> cache) {
        cache.getValueDataConversion();
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithEncoding_Class_Class(SecureCache<String, String> cache) {
        cache.withEncoding(IdentityEncoder.class, IdentityEncoder.class);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithWrapping_Class(SecureCache<String, String> cache) {
        cache.withWrapping(ByteArrayWrapper.class);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithWrapping_Class_Class(SecureCache<String, String> cache) {
        cache.withWrapping(ByteArrayWrapper.class, ByteArrayWrapper.class);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testCompute_Object_SerializableBiFunction(SecureCache<String, String> cache) {
        cache.compute((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testCompute_Object_SerializableBiFunction_long_TimeUnit(SecureCache<String, String> cache) {
        cache.compute((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", 1L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testCompute_Object_SerializableBiFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.compute((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testCompute_Object_SerializableBiFunction_Metadata(SecureCache<String, String> cache) {
        cache.compute((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfPresent_Object_SerializableBiFunction(SecureCache<String, String> cache) {
        cache.computeIfPresent((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfPresent_Object_SerializableBiFunction_Metadata(SecureCache<String, String> cache) {
        cache.computeIfPresent((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsent_Object_SerializableFunction_Metadata(SecureCache<String, String> cache) {
        cache.computeIfAbsent((Object)"b", (SerializableFunction & Serializable)k -> "no", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsent_Object_SerializableFunction(SecureCache<String, String> cache) {
        cache.computeIfAbsent((Object)"b", (SerializableFunction & Serializable)k -> "no");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsent_Object_SerializableFunction_long_TimeUnit(SecureCache<String, String> cache) {
        cache.computeIfAbsent((Object)"b", (SerializableFunction & Serializable)k -> "no", 10L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsent_Object_SerializableFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.computeIfAbsent((Object)"b", (SerializableFunction & Serializable)k -> "no", 10L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMerge_Object_Object_SerializableBiFunction(SecureCache<String, String> cache) {
        cache.merge((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no");
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMerge_Object_Object_SerializableBiFunction_long_TimeUnit(SecureCache<String, String> cache) {
        cache.merge((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no", 1L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMerge_Object_Object_SerializableBiFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) {
        cache.merge((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMerge_Object_Object_SerializableBiFunction_Metadata(SecureCache<String, String> cache) {
        cache.merge((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no", this.metadata);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithKeyEncoding_Class(SecureCache<String, String> cache) {
        cache.withKeyEncoding(IdentityEncoder.class);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithMediaType_String_String(SecureCache<String, String> cache) {
        cache.withMediaType("application/x-java-object", "application/x-java-object");
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithMediaType_MediaType_MediaType(SecureCache<String, String> cache) {
        cache.withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OBJECT);
    }

    @TestCachePermission(value=AuthorizationPermission.NONE)
    public void testWithStorageMediaType(SecureCache<String, String> cache) {
        cache.withStorageMediaType();
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddStorageFormatFilteredListener_Object_CacheEventFilter_CacheEventConverter_Set(SecureCache<String, String> cache) {
        cache.addStorageFormatFilteredListener((Object)this.listener, this.keyValueFilter, this.converter, Collections.emptySet());
    }

    @TestCachePermission(value=AuthorizationPermission.LISTEN)
    public void testAddStorageFormatFilteredListenerAsync_Object_CacheEventFilter_CacheEventConverter_Set(SecureCache<String, String> cache) {
        CompletionStages.join((CompletionStage)cache.addStorageFormatFilteredListenerAsync((Object)this.listener, this.keyValueFilter, this.converter, Collections.emptySet()));
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsentAsync_Object_SerializableFunction(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfAbsentAsync((Object)"b", (SerializableFunction & Serializable)k -> "no").get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsentAsync_Object_SerializableFunction_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfAbsentAsync((Object)"b", (SerializableFunction & Serializable)k -> "no", 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsentAsync_Object_SerializableFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfAbsentAsync((Object)"b", (SerializableFunction & Serializable)k -> "no", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfAbsentAsync_Object_SerializableFunction_Metadata(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfAbsentAsync((Object)"b", (SerializableFunction & Serializable)k -> "no", this.metadata).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMergeAsync_Object_Object_SerializableBiFunction(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.mergeAsync((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no").get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMergeAsync_Object_Object_SerializableBiFunction_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.mergeAsync((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no", 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMergeAsync_Object_Object_SerializableBiFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.mergeAsync((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testMergeAsync_Object_Object_SerializableBiFunction_Metadata(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.mergeAsync((Object)"a", (Object)"b", (SerializableBiFunction & Serializable)(k, v) -> "no", this.metadata).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfPresentAsync_Object_SerializableBiFunction(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfPresentAsync((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes").get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfPresentAsync_Object_SerializableBiFunction_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfPresentAsync((Object)"a", (k, v) -> "yes", 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfPresentAsync_Object_SerializableBiFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfPresentAsync((Object)"a", (k, v) -> "yes", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeIfPresentAsync_Object_SerializableBiFunction_Metadata(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeIfPresentAsync((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", this.metadata).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeAsync_Object_SerializableBiFunction(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeAsync((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes").get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeAsync_Object_SerializableBiFunction_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeAsync((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeAsync_Object_SerializableBiFunction_long_TimeUnit_long_TimeUnit(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeAsync((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS).get();
    }

    @TestCachePermission(value=AuthorizationPermission.WRITE)
    public void testComputeAsync_Object_SerializableBiFunction_Metadata(SecureCache<String, String> cache) throws ExecutionException, InterruptedException {
        cache.computeAsync((Object)"a", (SerializableBiFunction & Serializable)(k, v) -> "yes", this.metadata).get();
    }

    @Listener
    public static class NullListener {
    }
}

