/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.SecureListenerTest")
public class SecureListenerTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    static final Subject SUBJECT_A = TestingUtil.makeSubject("A", "listener");
    static final Subject SUBJECT_B = TestingUtil.makeSubject("B", "listener");

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("listener").permission(AuthorizationPermission.LISTEN).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("listener").role("admin");
        return TestCacheManagerFactory.createCacheManager(global, config);
    }

    @Override
    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SecureListenerTest.this.cacheManager = SecureListenerTest.this.createCacheManager();
                if (SecureListenerTest.this.cache == null) {
                    SecureListenerTest.this.cache = SecureListenerTest.this.cacheManager.getCache();
                }
                return null;
            }
        });
    }

    public void testSecureListenerSubject() {
        this.registerListener(SUBJECT_A);
        this.registerListener(SUBJECT_B);
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureListenerTest.this.cacheManager.getCache().put((Object)"key", (Object)"value");
                return null;
            }
        });
    }

    private void registerListener(final Subject subject) {
        Security.doAs((Subject)subject, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureListenerTest.this.cacheManager.getCache().addListener((Object)new SubjectVerifyingListener(subject));
                return null;
            }
        });
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureListenerTest.super.teardown();
                return null;
            }
        });
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureListenerTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    @Listener
    public static final class SubjectVerifyingListener {
        final Subject subject;

        public SubjectVerifyingListener(Subject subject) {
            this.subject = subject;
        }

        @CacheEntryCreated
        public void handleCreated(CacheEntryCreatedEvent<String, String> event) {
            AssertJUnit.assertEquals((Object)this.subject, (Object)Security.getSubject());
        }
    }
}

