/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Role;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="security.SecurityXmlFileParsingTest")
public class SecurityXmlFileParsingTest
extends AbstractInfinispanTest {
    Subject ADMIN = TestingUtil.makeSubject("admin");

    public void testParseAndConstructUnifiedXmlFile() throws Exception {
        Security.doAs((Subject)this.ADMIN, () -> {
            TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.fromXml("configs/security.xml", true)){

                @Override
                public void call() {
                    GlobalConfiguration g = this.cm.getCacheManagerConfiguration();
                    AssertJUnit.assertTrue((boolean)g.security().authorization().enabled());
                    AssertJUnit.assertEquals(IdentityRoleMapper.class, g.security().authorization().principalRoleMapper().getClass());
                    Map globalRoles = g.security().authorization().roles();
                    AssertJUnit.assertTrue((boolean)globalRoles.containsKey("supervisor"));
                    AssertJUnit.assertTrue((boolean)((Role)globalRoles.get("supervisor")).getPermissions().containsAll(Arrays.asList(AuthorizationPermission.READ, AuthorizationPermission.WRITE, AuthorizationPermission.EXEC)));
                    Configuration c = this.cm.getCache("secured").getCacheConfiguration();
                    AssertJUnit.assertTrue((boolean)c.security().authorization().enabled());
                    c.security().authorization().roles().containsAll(Arrays.asList("admin", "reader", "writer"));
                }
            });
            return null;
        });
    }
}

