/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.topology.CacheJoinCommand;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="statetransfer.ConcurrentStartTest", groups={"functional"})
public class ConcurrentStartTest
extends MultipleCacheManagersTest {
    public static final String REPL_CACHE_NAME = "repl";
    public static final String DIST_CACHE_NAME = "dist";
    public static final String SCATTERED_CACHE_NAME = "scattered";

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    @Test(timeOut=60000L)
    public void testConcurrentStart() throws Exception {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        CheckPoint checkPoint = new CheckPoint();
        EmbeddedCacheManager cm1 = this.createCacheManager();
        EmbeddedCacheManager cm2 = this.createCacheManager();
        AssertJUnit.assertEquals((Object)ComponentStatus.INSTANTIATED, (Object)TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm1).getStatus());
        this.replaceInboundInvocationHandler(cm1, checkPoint, 0);
        AssertJUnit.assertEquals((Object)ComponentStatus.INSTANTIATED, (Object)TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm2).getStatus());
        this.replaceInboundInvocationHandler(cm2, checkPoint, 1);
        log.debugf("Cache managers created. Starting the caches", new Object[0]);
        Future<Object> repl1Future = this.fork(new CacheStartCallable(cm1, REPL_CACHE_NAME));
        Future<Object> repl2Future = this.fork(new CacheStartCallable(cm2, REPL_CACHE_NAME));
        Future<Object> dist1Future = this.fork(new CacheStartCallable(cm1, DIST_CACHE_NAME));
        Future<Object> dist2Future = this.fork(new CacheStartCallable(cm2, DIST_CACHE_NAME));
        Future<Object> scat1Future = this.fork(new CacheStartCallable(cm1, SCATTERED_CACHE_NAME));
        Future<Object> scat2Future = this.fork(new CacheStartCallable(cm2, SCATTERED_CACHE_NAME));
        checkPoint.peek(2L, TimeUnit.SECONDS, "blocked_0", "blocked_1");
        checkPoint.trigger("unblocked_0", 999999999);
        checkPoint.trigger("unblocked_1", 999999999);
        repl1Future.get(10L, TimeUnit.SECONDS);
        repl2Future.get(10L, TimeUnit.SECONDS);
        dist1Future.get(10L, TimeUnit.SECONDS);
        dist2Future.get(10L, TimeUnit.SECONDS);
        scat1Future.get(10L, TimeUnit.SECONDS);
        scat2Future.get(10L, TimeUnit.SECONDS);
        Cache c1r = cm1.getCache(REPL_CACHE_NAME);
        Cache c1d = cm1.getCache(DIST_CACHE_NAME);
        Cache c2r = cm2.getCache(REPL_CACHE_NAME);
        Cache c2d = cm2.getCache(DIST_CACHE_NAME);
        Cache c1s = cm2.getCache(SCATTERED_CACHE_NAME);
        Cache c2s = cm2.getCache(SCATTERED_CACHE_NAME);
        TestingUtil.blockUntilViewsReceived(10000L, new CacheContainer[]{cm1, cm2});
        TestingUtil.waitForNoRebalance(c1r, c2r);
        TestingUtil.waitForNoRebalance(c1d, c2d);
        TestingUtil.waitForNoRebalance(c1s, c2s);
        c1r.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)c2r.get((Object)"key")));
        c1d.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)c2d.get((Object)"key")));
        c1s.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)c2s.get((Object)"key")));
    }

    private EmbeddedCacheManager createCacheManager() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.transport().defaultTransport();
        TestCacheManagerFactory.amendGlobalConfiguration(gcb, new TransportFlags());
        ConfigurationBuilder defaultCacheConfig = new ConfigurationBuilder();
        EmbeddedCacheManager cm = TestCacheManagerFactory.newDefaultCacheManager(false, gcb, defaultCacheConfig);
        this.registerCacheManager(new CacheContainer[]{cm});
        Configuration replCfg = new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build();
        cm.defineConfiguration(REPL_CACHE_NAME, replCfg);
        Configuration distCfg = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).build();
        cm.defineConfiguration(DIST_CACHE_NAME, distCfg);
        Configuration scatteredCfg = new ConfigurationBuilder().clustering().cacheMode(CacheMode.SCATTERED_SYNC).build();
        cm.defineConfiguration(SCATTERED_CACHE_NAME, scatteredCfg);
        return cm;
    }

    private void replaceInboundInvocationHandler(EmbeddedCacheManager cm, CheckPoint checkPoint, int index) {
        InboundInvocationHandler handler = TestingUtil.extractGlobalComponent((CacheContainer)cm, InboundInvocationHandler.class);
        BlockingInboundInvocationHandler ourHandler = new BlockingInboundInvocationHandler(handler, checkPoint, index);
        TestingUtil.replaceComponent((CacheContainer)cm, InboundInvocationHandler.class, ourHandler, true);
    }

    private static class BlockingInboundInvocationHandler
    implements InboundInvocationHandler {
        private Log log = LogFactory.getLog(ConcurrentStartTest.class);
        private final CheckPoint checkPoint;
        private final InboundInvocationHandler delegate;
        private final int index;

        public BlockingInboundInvocationHandler(InboundInvocationHandler delegate, CheckPoint checkPoint, int index) {
            this.delegate = delegate;
            this.checkPoint = checkPoint;
            this.index = index;
        }

        public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
            if (command instanceof CacheJoinCommand) {
                try {
                    this.checkPoint.trigger("blocked_" + this.index);
                    this.checkPoint.awaitStrict("unblocked_" + this.index, 10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.log.warnf((Throwable)e, "Error while blocking before command %s", (Object)command);
                }
            }
            this.delegate.handleFromCluster(origin, command, reply, order);
        }

        public void handleFromRemoteSite(String origin, XSiteReplicateCommand command, Reply reply, DeliverOrder order) {
            this.delegate.handleFromRemoteSite(origin, command, reply, order);
        }
    }

    private static class CacheStartCallable
    implements Callable<Object> {
        private final EmbeddedCacheManager cm;
        private final String cacheName;

        public CacheStartCallable(EmbeddedCacheManager cm, String cacheName) {
            this.cm = cm;
            this.cacheName = cacheName;
        }

        @Override
        public Object call() throws Exception {
            this.cm.getCache(this.cacheName);
            return null;
        }
    }
}

