/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.GetWithForceWriteLockRetryTest")
@CleanupAfterMethod
public class GetWithForceWriteLockRetryTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() {
        this.createCluster(TestDataSCI.INSTANCE, this.buildConfig(), 3);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder buildConfig() {
        ConfigurationBuilder configurationBuilder = GetWithForceWriteLockRetryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        configurationBuilder.clustering().hash().numSegments(60);
        configurationBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        return configurationBuilder;
    }

    public void testRetryAfterLeave() throws Exception {
        EmbeddedCacheManager cm1 = this.manager(0);
        Cache c1 = cm1.getCache();
        EmbeddedCacheManager cm2 = this.manager(1);
        Cache c2 = cm2.getCache();
        EmbeddedCacheManager cm3 = this.manager(2);
        Cache c3 = cm3.getCache();
        DelayInterceptor di3 = new DelayInterceptor(LockControlCommand.class, c3);
        TestingUtil.extractInterceptorChain(c3).addInterceptorBefore((AsyncInterceptor)di3, PessimisticLockingInterceptor.class);
        MagicKey key = new MagicKey(c3);
        TransactionManager tm1 = this.tm(c1);
        Future<Object> f = this.fork(() -> {
            log.tracef("Initiating a transaction on backup owner %s", (Object)c2);
            tm1.begin();
            try {
                c1.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get(key);
            }
            finally {
                tm1.commit();
            }
            return null;
        });
        di3.waitUntilBlocked(1);
        this.killMember(2);
        TestingUtil.waitForNoRebalance(c1, c2);
        f.get(10L, TimeUnit.SECONDS);
        di3.unblock(1);
    }

    class DelayInterceptor
    extends DDAsyncInterceptor {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final CheckPoint checkPoint = new CheckPoint();
        private final Class<?> commandToBlock;
        private final Cache<?, ?> cache;

        public DelayInterceptor(Class<?> commandToBlock, Cache<?, ?> cache) {
            this.commandToBlock = commandToBlock;
            this.cache = cache;
        }

        public int getCounter() {
            return this.counter.get();
        }

        public void waitUntilBlocked(int count) throws TimeoutException, InterruptedException {
            String event = this.checkPoint.peek(5L, TimeUnit.SECONDS, "blocked_" + count + "_on_" + this.cache);
            AssertJUnit.assertEquals((String)("blocked_" + count + "_on_" + this.cache), (String)event);
        }

        public void unblock(int count) throws InterruptedException, TimeoutException, BrokenBarrierException {
            log.tracef("Unblocking command on cache %s", this.cache);
            this.checkPoint.awaitStrict("blocked_" + count + "_on_" + this.cache, 5L, TimeUnit.SECONDS);
            this.checkPoint.trigger("resume_" + count + "_on_" + this.cache);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.invokeNextThenAccept(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
                if (!ctx.isInTxScope() && !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                    this.doBlock(ctx, (ReplicableCommand)command);
                }
            });
        }

        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            return this.invokeNextThenAccept((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
                if (!ctx.getCacheTransaction().isFromStateTransfer()) {
                    this.doBlock((InvocationContext)ctx, (ReplicableCommand)command);
                }
            });
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.invokeNextThenAccept((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
                if (!ctx.getCacheTransaction().isFromStateTransfer()) {
                    this.doBlock((InvocationContext)ctx, (ReplicableCommand)command);
                }
            });
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            return this.invokeNextThenAccept((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
                if (!ctx.getCacheTransaction().isFromStateTransfer()) {
                    this.doBlock((InvocationContext)ctx, (ReplicableCommand)command);
                }
            });
        }

        private void doBlock(InvocationContext ctx, ReplicableCommand command) throws InterruptedException, TimeoutException {
            if (this.commandToBlock != command.getClass()) {
                return;
            }
            log.tracef("Delaying command %s originating from %s", (Object)command, (Object)ctx.getOrigin());
            Integer myCount = this.counter.incrementAndGet();
            this.checkPoint.trigger("blocked_" + myCount + "_on_" + this.cache);
            this.checkPoint.awaitStrict("resume_" + myCount + "_on_" + this.cache, 15L, TimeUnit.SECONDS);
            log.tracef("Command unblocked: %s", (Object)command);
        }

        public String toString() {
            return "DelayInterceptor{counter=" + this.counter + "}";
        }
    }
}

