/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.globalstate.NoOpGlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.BlockingLocalTopologyManager;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="statetransfer.LeaveDuringStateTransferTest", description="One instance of ISPN-5021")
public class LeaveDuringStateTransferTest
extends MultipleCacheManagersTest {
    private ControlledConsistentHashFactory.Default factory = new ControlledConsistentHashFactory.Default(0, 1);

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = this.configuration();
        this.createClusteredCaches(3, cb, new TransportFlags().withFD(true));
    }

    private ConfigurationBuilder configuration() {
        ConfigurationBuilder cb = LeaveDuringStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        cb.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)this.factory);
        return cb;
    }

    @Override
    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager cm) {
        NoOpGlobalConfigurationManager.amendCacheManager(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        int startTopologyId = this.currentTopologyId(this.cache(0));
        BlockingLocalTopologyManager localTopologyManager0 = BlockingLocalTopologyManager.replaceTopologyManagerDefaultCache((EmbeddedCacheManager)this.cacheManagers.get(0));
        BlockingLocalTopologyManager localTopologyManager2 = BlockingLocalTopologyManager.replaceTopologyManagerDefaultCache((EmbeddedCacheManager)this.cacheManagers.get(2));
        try {
            this.factory.setOwnerIndexes(1, 2);
            this.addClusterEnabledCacheManager(this.configuration(), new TransportFlags().withFD(true));
            Future<Cache> joiner = this.fork(() -> ((EmbeddedCacheManager)this.cacheManagers.get(3)).getCache());
            BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, localTopologyManager0, localTopologyManager2);
            BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL, localTopologyManager0, localTopologyManager2);
            localTopologyManager0.expectTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL).unblock();
            localTopologyManager2.expectTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL).unblock();
            BlockingLocalTopologyManager.BlockedConfirmation blockedConfirmation0 = localTopologyManager0.expectPhaseConfirmation();
            BlockingLocalTopologyManager.BlockedConfirmation blockedConfirmation2 = localTopologyManager2.expectPhaseConfirmation();
            log.debug((Object)"State transfer almost complete");
            this.eventually(() -> this.currentTopologyId(this.cache(2)) == startTopologyId + 3);
            log.debug((Object)("Isolating node " + this.cacheManagers.get(1)));
            TestingUtil.getDiscardForCache(this.manager(1)).setDiscardAll(true);
            TestingUtil.blockUntilViewsReceived(60000, true, this.cacheManagers);
            log.debug((Object)"Waiting for topology update from view change");
            BlockingLocalTopologyManager.BlockedTopology blockedTopology0 = localTopologyManager0.expectTopologyUpdate();
            BlockingLocalTopologyManager.BlockedTopology blockedTopology2 = localTopologyManager2.expectTopologyUpdate();
            blockedConfirmation0.unblock();
            blockedConfirmation2.unblock();
            blockedTopology0 = this.blockNewRebalance(localTopologyManager0, blockedTopology0);
            blockedTopology2 = this.blockNewRebalance(localTopologyManager2, blockedTopology2);
            this.eventually(() -> this.currentTopologyId(this.cache(0)) == startTopologyId + 4);
            this.cache(0).put((Object)"key", (Object)"value");
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache(2).get((Object)"key"));
            blockedTopology0.unblock();
            blockedTopology2.unblock();
            localTopologyManager0.expectPhaseConfirmation().unblock();
            localTopologyManager2.expectPhaseConfirmation().unblock();
            BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL, localTopologyManager0, localTopologyManager2);
            BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL, localTopologyManager0, localTopologyManager2);
            BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.NO_REBALANCE, localTopologyManager0, localTopologyManager2);
            joiner.get(10L, TimeUnit.SECONDS);
        }
        finally {
            localTopologyManager2.stopBlocking();
            localTopologyManager0.stopBlocking();
        }
    }

    private BlockingLocalTopologyManager.BlockedTopology blockNewRebalance(BlockingLocalTopologyManager ltm, BlockingLocalTopologyManager.BlockedTopology blockedTopology) throws InterruptedException {
        if (blockedTopology.getCacheTopology().getPhase() == CacheTopology.Phase.READ_NEW_WRITE_ALL) {
            BlockingLocalTopologyManager.BlockedTopology newTopology = ltm.expectTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL);
            blockedTopology.unblock();
            ltm.expectPhaseConfirmation().unblock();
            return newTopology;
        }
        AssertJUnit.assertEquals((Object)CacheTopology.Phase.READ_OLD_WRITE_ALL, (Object)blockedTopology.getCacheTopology().getPhase());
        ltm.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        return blockedTopology;
    }

    private int currentTopologyId(Cache cache) {
        return TestingUtil.extractComponent(cache, DistributionManager.class).getCacheTopology().getTopologyId();
    }
}

