/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Arrays;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.ReplicatedControlledConsistentHashFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.OrphanTransactionsCleanupTest")
public class OrphanTransactionsCleanupTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(OrphanTransactionsCleanupTest.class);
    protected ConfigurationBuilder configurationBuilder;

    public OrphanTransactionsCleanupTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = OrphanTransactionsCleanupTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        this.configurationBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.configurationBuilder.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
        this.configurationBuilder.clustering().stateTransfer().awaitInitialTransfer(false);
        this.addClusterEnabledCacheManager(this.configurationBuilder);
        this.addClusterEnabledCacheManager(this.configurationBuilder);
        this.waitForClusterToForm();
    }

    public void testJoinerTransactionSurvives() throws Exception {
        Cache c0 = this.manager(0).getCache();
        Cache c1 = this.manager(1).getCache();
        TransactionTable tt0 = TestingUtil.extractComponent(c0, TransactionTable.class);
        LocalTopologyManager ltm0 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), LocalTopologyManager.class);
        ltm0.setRebalancingEnabled(false);
        this.addClusterEnabledCacheManager(this.configurationBuilder);
        Cache c2 = this.manager(2).getCache();
        this.tm(2).begin();
        c2.put((Object)"key1", (Object)"value1");
        AssertJUnit.assertEquals((int)1, (int)tt0.getRemoteGlobalTransaction().size());
        Transaction tx2 = this.tm(2).suspend();
        this.tm(1).begin();
        c1.put((Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((int)2, (int)tt0.getRemoteGlobalTransaction().size());
        Transaction tx1 = this.tm(1).suspend();
        this.manager(1).stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, c0, c2);
        TestingUtil.waitForNoRebalance(c0);
        AssertJUnit.assertEquals(Arrays.asList(this.address(0)), (Object)c0.getAdvancedCache().getDistributionManager().getWriteConsistentHash().getMembers());
        this.eventuallyEquals(1, () -> tt0.getRemoteTransactions().size());
        this.tm(2).resume(tx2);
        this.tm(2).commit();
    }
}

