/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.PrepareTimeoutTest")
@CleanupAfterMethod
public class PrepareTimeoutTest
extends MultipleCacheManagersTest {
    private static final String TEST_KEY = "key";
    private static final String TX1_VALUE = "value1";
    private static final Object TX2_VALUE = "value2";
    public static final int COMPLETED_TX_TIMEOUT = 2000;

    @Override
    protected void createCacheManagers() throws Throwable {
        ControlledConsistentHashFactory.Default consistentHashFactory = new ControlledConsistentHashFactory.Default(1, 2);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.clustering().remoteTimeout(2000L);
        builder.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)consistentHashFactory);
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().completedTxTimeout(2000L);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.waitForClusterToForm();
    }

    public void testCommitDoesntWriteAfterRollback() throws Exception {
        StateSequencer sequencer = new StateSequencer();
        sequencer.logicalThread("main", "main:start", "main:check");
        sequencer.logicalThread("primary", "primary:block_prepare", "primary:after_rollback", "primary:resume_prepare", "primary:after_prepare");
        sequencer.logicalThread("backup", "backup:block_prepare", "backup:after_rollback", "backup:resume_prepare", "backup:after_prepare");
        sequencer.order("main:start", "primary:block_prepare", "primary:after_prepare", "main:check");
        sequencer.order("main:start", "backup:block_prepare", "backup:after_prepare", "main:check");
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(1), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(VersionedPrepareCommand.class).matchCount(0).build()).before("primary:block_prepare", "primary:resume_prepare").after("primary:after_prepare", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(1), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(RollbackCommand.class).build()).after("primary:after_rollback", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(VersionedPrepareCommand.class).matchCount(0).build()).before("backup:block_prepare", "backup:resume_prepare").after("backup:after_prepare", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(RollbackCommand.class).build()).after("backup:after_rollback", new String[0]);
        AssertJUnit.assertEquals(Arrays.asList(this.address(1), this.address(2)), (Object)this.cacheTopology(0).getDistribution((Object)TEST_KEY).writeOwners());
        sequencer.advance("main:start");
        this.tm(0).begin();
        this.cache(0).put((Object)TEST_KEY, (Object)TX1_VALUE);
        try {
            this.tm(0).commit();
            AssertJUnit.fail((String)"Exception expected during commit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tm(0).begin();
        this.cache(0).put((Object)TEST_KEY, TX2_VALUE);
        GlobalTransaction gtx1 = this.transactionTable(0).getLocalTransaction(this.tm(0).getTransaction()).getGlobalTransaction();
        this.tm(0).commit();
        Thread.sleep(3000L);
        AssertJUnit.assertTrue((boolean)this.transactionTable(1).isTransactionCompleted(gtx1));
        AssertJUnit.assertTrue((boolean)this.transactionTable(2).isTransactionCompleted(gtx1));
        sequencer.advance("main:check");
        LockManager lockManager1 = TestingUtil.extractLockManager(this.cache(1));
        AssertJUnit.assertFalse((boolean)lockManager1.isLocked((Object)TEST_KEY));
        AssertJUnit.assertFalse((boolean)this.transactionTable(1).containRemoteTx(gtx1));
        AssertJUnit.assertFalse((boolean)this.transactionTable(2).containRemoteTx(gtx1));
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((Object)TX2_VALUE, (Object)cache.get((Object)TEST_KEY));
        }
    }
}

