/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.ReadAfterLostOwnershipTestSCIImpl;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.BaseControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.ReadAfterLosingOwnershipTest")
@CleanupAfterMethod
public class ReadAfterLosingOwnershipTest
extends MultipleCacheManagersTest {
    private boolean l1 = false;

    @Override
    public Object[] factory() {
        return new Object[]{new ReadAfterLosingOwnershipTest().transactional(true), new ReadAfterLosingOwnershipTest().transactional(false), new ReadAfterLosingOwnershipTest().l1(true).transactional(true), new ReadAfterLosingOwnershipTest().l1(true).transactional(false)};
    }

    public ReadAfterLosingOwnershipTest l1(boolean l1) {
        this.l1 = l1;
        return this;
    }

    @Override
    protected String parameters() {
        return "[tx=" + this.transactional + ", l1=" + this.l1 + "]";
    }

    public void testOwnershipLostWithPut() throws Exception {
        this.doOwnershipLostTest(Operation.PUT, false);
    }

    public void testOwnershipLostWithRemove() throws Exception {
        this.doOwnershipLostTest(Operation.REMOVE, false);
    }

    public void testOwnershipLostWithPutOnOwner() throws Exception {
        this.doOwnershipLostTest(Operation.PUT, true);
    }

    public void testOwnershipLostWithRemoveOnOwner() throws Exception {
        this.doOwnershipLostTest(Operation.REMOVE, true);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, ReadAfterLostOwnershipTestSCI.INSTANCE, this.createConfigurationBuilder());
    }

    protected final ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = ReadAfterLosingOwnershipTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, this.transactional);
        builder.clustering().hash().numOwners(2).consistentHashFactory((ConsistentHashFactory)new SingleKeyConsistentHashFactory()).numSegments(1).l1().enabled(this.l1).stateTransfer().fetchInMemoryState(true);
        return builder;
    }

    private void doOwnershipLostTest(Operation operation, boolean onOwner) throws ExecutionException, InterruptedException {
        log.debug((Object)"Initialize cache");
        this.cache(0).put((Object)"key", (Object)"value0");
        this.assertCachesKeyValue("key", "value0");
        StateConsumerImpl stateConsumer = (StateConsumerImpl)TestingUtil.extractComponent(this.cache(1), StateConsumer.class);
        Listener listener = new Listener();
        stateConsumer.setKeyInvalidationListener((StateConsumerImpl.KeyInvalidationListener)listener);
        log.debug((Object)"Add a 3rd node");
        this.addClusterEnabledCacheManager(ReadAfterLostOwnershipTestSCI.INSTANCE, this.createConfigurationBuilder());
        Future<Void> join = this.fork(() -> {
            this.waitForClusterToForm();
            log.debug((Object)"3rd has join");
        });
        log.debug((Object)"Waiting for command to block");
        listener.notifier.await();
        log.debug((Object)"Set a new value");
        operation.update(onOwner ? this.cache(0) : this.cache(1));
        this.assertCachesKeyValue((Object)"key", operation.finalValue(), this.cache(0), this.cache(1));
        listener.wait.countDown();
        log.debug((Object)"Waiting for the 3rd node to join");
        join.get();
        this.assertCachesKeyValue("key", operation.finalValue());
    }

    private void assertCachesKeyValue(Object key, Object value) {
        this.assertCachesKeyValue(key, value, this.caches());
    }

    private void assertCachesKeyValue(Object key, Object value, Cache<Object, Object> ... caches) {
        this.assertCachesKeyValue(key, value, Arrays.asList(caches));
    }

    private void assertCachesKeyValue(Object key, Object value, Collection<Cache<Object, Object>> caches) {
        for (Cache<Object, Object> cache : caches) {
            AssertJUnit.assertEquals((String)("Wrong key value for " + this.address(cache)), (Object)value, (Object)cache.get(key));
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={SingleKeyConsistentHashFactory.class}, schemaFileName="test.core.ReadAfterLostOwnershipTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.ReadAfterLostOwnershipTest", service=false)
    static interface ReadAfterLostOwnershipTestSCI
    extends SerializationContextInitializer {
        public static final ReadAfterLostOwnershipTestSCI INSTANCE = new ReadAfterLostOwnershipTestSCIImpl();
    }

    public class Listener
    implements StateConsumerImpl.KeyInvalidationListener {
        public final CountDownLatch notifier = new CountDownLatch(1);
        final CountDownLatch wait = new CountDownLatch(1);

        public void beforeInvalidation(IntSet removedSegments, IntSet staleL1Segments) {
            log.debugf("Before invalidation: removedSegments=%s, staleL1Segments=%s", (Object)removedSegments, (Object)staleL1Segments);
            if (!removedSegments.contains(0)) {
                return;
            }
            this.notifier.countDown();
            try {
                TestBlocking.await(this.wait, 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @ProtoName(value="ReadAfterSingleKeyConsistentHashFactory")
    public static class SingleKeyConsistentHashFactory
    extends BaseControlledConsistentHashFactory.Default {
        SingleKeyConsistentHashFactory() {
            super(1);
        }

        @Override
        protected final int[][] assignOwners(int numSegments, List<Address> members) {
            switch (members.size()) {
                case 1: {
                    return new int[][]{{0}};
                }
                case 2: {
                    return new int[][]{{0, 1}};
                }
            }
            return new int[][]{{0, members.size() - 1}};
        }
    }

    private static enum Operation {
        PUT,
        REMOVE;


        public void update(Cache<Object, Object> cache) {
            if (this == PUT) {
                cache.put((Object)"key", (Object)"value1");
            } else {
                cache.remove((Object)"key");
            }
        }

        public Object finalValue() {
            return this == PUT ? "value1" : null;
        }
    }
}

