/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.topology.TopologyUpdateCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.remoting.transport.ControlledTransport;
import org.infinispan.statetransfer.DelegatingStateTransferLock;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.ClusterTopologyManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.ReadAfterLostDataTest")
@InCacheMode(value={CacheMode.DIST_SYNC})
@CleanupAfterMethod
public class ReadAfterLostDataTest
extends MultipleCacheManagersTest {
    private List<Runnable> cleanup = new ArrayList<Runnable>();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(PartitionHandling.ALLOW_READ_WRITES);
        this.createClusteredCaches(4, TestDataSCI.INSTANCE, cb, new TransportFlags().withFD(true).withMerge(true), new String[0]);
    }

    @AfterMethod
    protected void cleanup() {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
    }

    public void testGet() throws Exception {
        this.test(ReadAfterLostDataTest::get, false, false);
    }

    public void testGetBeforeTopologyUpdate() throws Exception {
        this.test(ReadAfterLostDataTest::get, false, true);
    }

    public void testGetAll() throws Exception {
        this.test(ReadAfterLostDataTest::getAll, false, false);
    }

    public void testGetAllBeforeTopologyUpdate() throws Exception {
        this.test(ReadAfterLostDataTest::getAll, false, true);
    }

    public void testPut() throws Exception {
        this.test(ReadAfterLostDataTest::put, true, false);
    }

    public void testRemove() throws Exception {
        this.test(ReadAfterLostDataTest::remove, true, false);
    }

    public void testReplace() throws Exception {
        this.test(ReadAfterLostDataTest::replace, true, false);
    }

    public void testPutMap() throws Exception {
        this.test(ReadAfterLostDataTest::putMap, true, false);
    }

    public void testPutMapBeforeTopologyUpdate() throws Exception {
        this.test(ReadAfterLostDataTest::putMap, true, true);
    }

    public void testRead() throws Exception {
        this.test(ReadAfterLostDataTest::read, false, false);
    }

    public void testReadBeforeTopologyUpdate() throws Exception {
        this.test(ReadAfterLostDataTest::read, false, true);
    }

    public void testReadMany() throws Exception {
        this.test(ReadAfterLostDataTest::readMany, false, false);
    }

    public void testReadManyBeforeTopologyUpdate() throws Exception {
        this.test(ReadAfterLostDataTest::readMany, false, true);
    }

    public void testReadWrite() throws Exception {
        this.test(ReadAfterLostDataTest::readWrite, false, false);
    }

    public void testReadWriteMany() throws Exception {
        this.test(ReadAfterLostDataTest::readWriteMany, false, false);
    }

    public void testReadWriteManyBeforeTopologyUpdate() throws Exception {
        this.test(ReadAfterLostDataTest::readWriteMany, true, true);
    }

    protected void test(BiFunction<Cache<Object, Object>, Collection<?>, Map<?, ?>> operation, boolean write, boolean blockUpdates) throws Exception {
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add(this.getKeyForCache(this.cache(0), this.cache(1)));
        keys.add(this.getKeyForCache(this.cache(0), this.cache(2)));
        keys.add(this.getKeyForCache(this.cache(2), this.cache(1)));
        keys.add(this.getKeyForCache(this.cache(2), this.cache(3)));
        for (int i = 0; i < keys.size(); ++i) {
            this.cache(0).put(keys.get(i), (Object)("value" + i));
        }
        for (Cache c : Arrays.asList(this.cache(0), this.cache(1))) {
            ClusterTopologyManager clusterTopologyManager = TestingUtil.extractComponent(c, ClusterTopologyManager.class);
            clusterTopologyManager.setRebalancingEnabled(false);
            if (!blockUpdates) continue;
            ControlledTransport blockedTopologyUpdates = ControlledTransport.replace(c);
            blockedTopologyUpdates.blockBefore(TopologyUpdateCommand.class);
            int currentTopology = c.getAdvancedCache().getDistributionManager().getCacheTopology().getTopologyId();
            this.cleanup.add(blockedTopologyUpdates::stopBlocking);
            TestingUtil.wrapComponent(this.cache(0), StateTransferLock.class, stl -> new UnblockingStateTransferLock((StateTransferLock)stl, currentTopology + 1, blockedTopologyUpdates::stopBlocking));
        }
        TestingUtil.crashCacheManagers(this.manager(2), this.manager(3));
        TestingUtil.installNewView(this.manager(0), this.manager(1));
        this.invokeOperation(this.cache(0), operation, keys);
        if (!write) {
            this.invokeOperation(this.cache(1), operation, keys);
        }
    }

    private void invokeOperation(Cache<Object, Object> cache, BiFunction<Cache<Object, Object>, Collection<?>, Map<?, ?>> operation, List<Object> keys) {
        Map<?, ?> result = operation.apply(cache, keys);
        AssertJUnit.assertEquals((Object)"value0", result.get(keys.get(0)));
        AssertJUnit.assertEquals((Object)"value1", result.get(keys.get(1)));
        AssertJUnit.assertEquals((Object)"value2", result.get(keys.get(2)));
        AssertJUnit.assertEquals(null, result.get(keys.get(3)));
        AssertJUnit.assertEquals((String)result.toString(), (int)3, (int)result.size());
    }

    private static Map<?, ?> get(Cache<Object, Object> cache, Collection<?> keys) {
        HashMap map = new HashMap();
        for (Object key : keys) {
            Object value = cache.get(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private static Map<?, ?> getAll(Cache<Object, Object> cache, Collection<?> keys) {
        return cache.getAdvancedCache().getAll(new HashSet(keys));
    }

    private static Map<?, ?> put(Cache<Object, Object> cache, Collection<?> keys) {
        HashMap map = new HashMap();
        int i = 0;
        for (Object key : keys) {
            Object value = cache.put(key, (Object)("other" + i++));
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private static Map<?, ?> putMap(Cache<Object, Object> cache, Collection<?> keys) {
        HashMap writeMap = new HashMap();
        int i = 0;
        for (Object key : keys) {
            writeMap.put(key, "other" + i++);
        }
        return cache.getAdvancedCache().getAndPutAll(writeMap);
    }

    private static Map<?, ?> remove(Cache<Object, Object> cache, Collection<?> keys) {
        HashMap map = new HashMap();
        for (Object key : keys) {
            Object value = cache.remove(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private static Map<?, ?> replace(Cache<Object, Object> cache, Collection<?> keys) {
        HashMap map = new HashMap();
        int i = 0;
        for (Object key : keys) {
            Object value = cache.replace(key, (Object)("other" + i++));
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private static Map<?, ?> read(Cache<Object, Object> cache, Collection<?> keys) {
        FunctionalMap.ReadOnlyMap ro = ReadOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache()));
        HashMap map = new HashMap();
        for (Object key : keys) {
            ((EntryView.ReadEntryView)ro.eval(key, MarshallableFunctions.identity()).join()).find().ifPresent(value -> map.put(key, value));
        }
        return map;
    }

    private static Map<?, ?> readMany(Cache<Object, Object> cache, Collection<?> keys) {
        FunctionalMap.ReadOnlyMap ro = ReadOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache()));
        return (Map)ro.evalMany(new HashSet(keys), MarshallableFunctions.identity()).filter(view -> view.find().isPresent()).collect(Collectors.toMap(EntryView.ReadEntryView::key, EntryView.ReadEntryView::get));
    }

    private static Map<?, ?> readWrite(Cache<Object, Object> cache, Collection<?> keys) {
        FunctionalMap.ReadWriteMap rw = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache()));
        HashMap map = new HashMap();
        for (Object key : keys) {
            ((EntryView.ReadWriteEntryView)rw.eval(key, MarshallableFunctions.identity()).join()).find().ifPresent(value -> map.put(key, value));
        }
        return map;
    }

    private static Map<?, ?> readWriteMany(Cache<Object, Object> cache, Collection<?> keys) {
        FunctionalMap.ReadWriteMap ro = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache()));
        return (Map)ro.evalMany(new HashSet(keys), MarshallableFunctions.identity()).filter(view -> view.find().isPresent()).collect(Collectors.toMap(EntryView.WriteEntryView::key, EntryView.ReadEntryView::get));
    }

    private static class UnblockingStateTransferLock
    extends DelegatingStateTransferLock {
        private final int topologyId;
        private final Runnable runnable;

        public UnblockingStateTransferLock(StateTransferLock delegate, int topologyId, Runnable runnable) {
            super(delegate);
            this.topologyId = topologyId;
            this.runnable = runnable;
        }

        @Override
        public CompletionStage<Void> transactionDataFuture(int expectedTopologyId) {
            if (expectedTopologyId >= this.topologyId) {
                this.runnable.run();
            }
            return super.transactionDataFuture(expectedTopologyId);
        }
    }
}

