/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.globalstate.NoOpGlobalConfigurationManager;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.RemoteGetDuringStateTransferSCIImpl;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.BaseControlledConsistentHashFactory;
import org.infinispan.util.BlockingLocalTopologyManager;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.RemoteGetDuringStateTransferTest")
@CleanupAfterMethod
public class RemoteGetDuringStateTransferTest
extends MultipleCacheManagersTest {
    private final List<BlockingLocalTopologyManager> topologyManagerList = Collections.synchronizedList(new ArrayList(4));
    private final List<ControlledRpcManager> rpcManagerList = Collections.synchronizedList(new ArrayList(4));

    @AfterMethod(alwaysRun=true)
    public final void unblockAll() {
        for (BlockingLocalTopologyManager topologyManager : this.topologyManagerList) {
            topologyManager.stopBlocking();
        }
        this.topologyManagerList.clear();
        for (ControlledRpcManager rpcManager : this.rpcManagerList) {
            rpcManager.stopBlocking();
        }
        this.rpcManagerList.clear();
    }

    public void testScenario_010() throws Exception {
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = "key_010";
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new AssertNoRetryInterceptor(), StateTransferInterceptor.class);
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.BlockedRequest<ClusteredGetCommand> blockedGet = rpcManager0.expectCommand(ClusteredGetCommand.class);
        FailReadsInterceptor fri = new FailReadsInterceptor();
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)fri));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager1);
        this.awaitForTopology(currentTopologyId + 1, this.cache(1));
        blockedGet.send().receiveAll();
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        fri.assertNotHit();
        this.assertTopologyId(currentTopologyId, this.cache(0));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, joiner.topologyManager);
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_011() throws Exception {
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = "key_011";
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new AssertNoRetryInterceptor(), StateTransferInterceptor.class);
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.BlockedRequest<ClusteredGetCommand> blockedGet = rpcManager0.expectCommand(ClusteredGetCommand.class);
        FailReadsInterceptor fri = new FailReadsInterceptor();
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)fri));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, topologyManager1);
        this.awaitForTopology(currentTopologyId + 1, this.cache(1));
        this.awaitForTopology(currentTopologyId + 1, this.cache(0));
        blockedGet.send().receiveAll();
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        fri.assertNotHit();
        this.assertTopologyId(currentTopologyId + 1, this.cache(1));
        this.assertTopologyId(currentTopologyId + 1, this.cache(0));
        joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL);
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_101() throws Exception {
        this.testScenario_1x1(0);
    }

    public void testScenario_111() throws Exception {
        this.testScenario_1x1(1);
    }

    protected void testScenario_1x1(int topologyOnNode1) throws Exception {
        AssertJUnit.assertTrue((0 <= topologyOnNode1 && topologyOnNode1 <= 1 ? 1 : 0) != 0);
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = String.format("key_1%d1", topologyOnNode1);
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new AssertNoRetryInterceptor(), StateTransferInterceptor.class);
        FailReadsInterceptor fri = new FailReadsInterceptor();
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)fri));
        topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL);
        if (topologyOnNode1 > 0) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL);
        }
        this.awaitForTopology(currentTopologyId + 1, this.cache(0));
        this.awaitForTopology(currentTopologyId + topologyOnNode1, this.cache(1));
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.BlockedRequest<ClusteredGetCommand> blockedGet = rpcManager0.expectCommand(ClusteredGetCommand.class);
        blockedGet.send().receiveAll();
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        fri.assertNotHit();
        this.assertTopologyId(currentTopologyId + 1, this.cache(0));
        if (topologyOnNode1 < 1) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL);
        }
        joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL);
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_032_22() throws Exception {
        this.testScenario_03x_yx(2, 2);
    }

    public void testScenario_032_32() throws Exception {
        this.testScenario_03x_yx(2, 3);
    }

    public void testScenario_033_23() throws Exception {
        this.testScenario_03x_yx(3, 2);
    }

    public void testScenario_033_33() throws Exception {
        this.testScenario_03x_yx(3, 3);
    }

    protected void testScenario_03x_yx(int topologyOnNode0, int topologyOnNode2) throws Exception {
        AssertJUnit.assertTrue((2 <= topologyOnNode0 && topologyOnNode0 <= 3 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((2 <= topologyOnNode2 && topologyOnNode2 <= 3 ? 1 : 0) != 0);
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = String.format("key_03%d_%d%d", topologyOnNode0, topologyOnNode2, topologyOnNode0);
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        this.assertTopologyId(currentTopologyId, this.cache(0));
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.BlockedRequest<ClusteredGetCommand> blockedGet = rpcManager0.expectCommand(ClusteredGetCommand.class);
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)new WaitForTopologyInterceptor(currentTopologyId + topologyOnNode2)));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        if (topologyOnNode0 > 2) {
            topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode2 > 2) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        this.awaitForTopology(currentTopologyId + 3, this.cache(1));
        this.awaitForTopology(currentTopologyId + topologyOnNode0, this.cache(0));
        blockedGet.send().receiveAll();
        rpcManager0.expectCommand(ClusteredGetCommand.class).send().receiveAll();
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        this.assertTopologyId(currentTopologyId + topologyOnNode0, this.cache(0));
        if (topologyOnNode0 < 3) {
            topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode2 < 3) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.NO_REBALANCE, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_132_22() throws Exception {
        this.testScenario_13x_yx(2, 2);
    }

    public void testScenario_132_32() throws Exception {
        this.testScenario_13x_yx(2, 3);
    }

    public void testScenario_133_23() throws Exception {
        this.testScenario_13x_yx(3, 2);
    }

    public void testScenario_133_33() throws Exception {
        this.testScenario_13x_yx(3, 3);
    }

    protected void testScenario_13x_yx(int topologyOnNode0, int topologyOnNode2) throws Exception {
        AssertJUnit.assertTrue((2 <= topologyOnNode0 && topologyOnNode0 <= 3 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((2 <= topologyOnNode2 && topologyOnNode2 <= 3 ? 1 : 0) != 0);
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = String.format("key_13%d_%d%d", topologyOnNode0, topologyOnNode2, topologyOnNode0);
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)new WaitForTopologyInterceptor(currentTopologyId + topologyOnNode2)));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        this.awaitForTopology(currentTopologyId + 1, this.cache(0));
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.BlockedRequest<ClusteredGetCommand> blockedGet = rpcManager0.expectCommand(ClusteredGetCommand.class);
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        if (topologyOnNode0 > 2) {
            topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode2 > 2) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        this.awaitForTopology(currentTopologyId + 3, this.cache(1));
        this.awaitForTopology(currentTopologyId + topologyOnNode0, this.cache(0));
        blockedGet.send().receiveAll();
        rpcManager0.expectCommand(ClusteredGetCommand.class).send().receiveAll();
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        this.assertTopologyId(currentTopologyId + topologyOnNode0, this.cache(0));
        if (topologyOnNode0 < 3) {
            topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode2 < 3) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.NO_REBALANCE, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_2112() throws Exception {
        this.testScenario_2xy2(1, 1, 1, 1);
    }

    public void testScenario_2212() throws Exception {
        this.testScenario_2xy2(2, 1, 1, 1);
    }

    public void testScenario_2122() throws Exception {
        this.testScenario_2xy2(1, 2, 2, -1);
    }

    public void testScenario_2132() throws Exception {
        this.testScenario_2xy2(1, 3, 2, -1);
    }

    public void testScenario_2222() throws Exception {
        this.testScenario_2xy2(2, 2, 2, -1);
    }

    public void testScenario_2232() throws Exception {
        this.testScenario_2xy2(2, 3, 2, -1);
    }

    public void testScenario_2322() throws Exception {
        this.testScenario_2xy2(3, 2, 1, 2);
    }

    public void testScenario_2332() throws Exception {
        this.testScenario_2xy2(3, 3, 1, 2);
    }

    protected void testScenario_2xy2(int topologyOnNode1, int topologyOnNode2, int expectedSuccessResponses, int expectSuccessFrom) throws Exception {
        AssertJUnit.assertTrue((1 <= topologyOnNode1 && topologyOnNode1 <= 3 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((1 <= topologyOnNode2 && topologyOnNode2 <= 3 ? 1 : 0) != 0);
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = String.format("key_2%d%d2", topologyOnNode1, topologyOnNode2);
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new AssertNoRetryInterceptor(), StateTransferInterceptor.class);
        WaitForTopologyInterceptor wfti = new WaitForTopologyInterceptor(currentTopologyId + topologyOnNode2);
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)wfti));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        this.awaitForTopology(currentTopologyId + 2, this.cache(0));
        if (topologyOnNode1 > 1) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        }
        if (topologyOnNode2 > 1) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        }
        if (topologyOnNode1 > 2) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        this.assertTopologyId(currentTopologyId + 2, this.cache(0));
        this.assertTopologyId(currentTopologyId + topologyOnNode1, this.cache(1));
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.SentRequest sentGet = rpcManager0.expectCommand(ClusteredGetCommand.class).send();
        sentGet.expectResponse(this.address(1));
        if (topologyOnNode1 < 2) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        }
        if (topologyOnNode2 > 2) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        this.eventuallyEquals(currentTopologyId + topologyOnNode2, () -> wfti.distributionManager.getCacheTopology().getTopologyId());
        ControlledRpcManager.BlockedResponseMap blockedGet = sentGet.expectAllResponses();
        int succesful = 0;
        for (Map.Entry<Address, Response> rsp : blockedGet.getResponses().entrySet()) {
            if (rsp.getValue().isSuccessful()) {
                if (expectSuccessFrom >= 0) {
                    AssertJUnit.assertEquals((Object)this.address(expectSuccessFrom), (Object)rsp.getKey());
                }
                ++succesful;
                continue;
            }
            AssertJUnit.assertEquals((Object)UnsureResponse.INSTANCE, (Object)rsp.getValue());
            if (expectSuccessFrom < 0) continue;
            AssertJUnit.assertFalse((boolean)rsp.getKey().equals(this.address(expectSuccessFrom)));
        }
        AssertJUnit.assertTrue((succesful == expectedSuccessResponses ? 1 : 0) != 0);
        blockedGet.receive();
        if (succesful == 0) {
            rpcManager0.expectCommand(ClusteredGetCommand.class).send().receiveAll();
        }
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        if (topologyOnNode2 < 2) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        }
        topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        if (topologyOnNode1 < 3) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode2 < 3) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.NO_REBALANCE, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_2312_22() throws Exception {
        this.testScenario_2312_x2(2);
    }

    public void testScenario_2312_32() throws Exception {
        this.testScenario_2312_x2(3);
    }

    private void testScenario_2312_x2(int retryTopologyOnNode2) throws Exception {
        AssertJUnit.assertTrue((2 <= retryTopologyOnNode2 && retryTopologyOnNode2 <= 3 ? 1 : 0) != 0);
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = String.format("key_2312_%d2", retryTopologyOnNode2);
        this.ownerCheckAndInit(this.cache(1), key, "v");
        ControlledRpcManager rpcManager0 = this.replaceRpcManager(this.cache(0));
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        CyclicBarrier barrier1 = new CyclicBarrier(2);
        CyclicBarrier barrier2 = new CyclicBarrier(2);
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor(new BlockingInterceptor<GetCacheEntryCommand>(barrier2, GetCacheEntryCommand.class, true, false)));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        this.awaitForTopology(currentTopologyId + 2, this.cache(0));
        this.cache(1).getAdvancedCache().getAsyncInterceptorChain().addInterceptor(new BlockingInterceptor<GetCacheEntryCommand>(barrier1, GetCacheEntryCommand.class, false, false), 0);
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        ControlledRpcManager.SentRequest sentGet = rpcManager0.expectCommand(ClusteredGetCommand.class).send();
        barrier2.await(10L, TimeUnit.SECONDS);
        barrier2.await(10L, TimeUnit.SECONDS);
        sentGet.expectResponse(this.address(2), (Response)UnsureResponse.INSTANCE).receive();
        topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        this.awaitForTopology(currentTopologyId + 3, this.cache(1));
        if (retryTopologyOnNode2 > 2) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        barrier1.await(10L, TimeUnit.SECONDS);
        barrier1.await(10L, TimeUnit.SECONDS);
        sentGet.expectResponse(this.address(1), (Response)UnsureResponse.INSTANCE).receive().finish();
        ControlledRpcManager.SentRequest sentRetry = rpcManager0.expectCommand(ClusteredGetCommand.class).send();
        barrier1.await(10L, TimeUnit.SECONDS);
        barrier1.await(10L, TimeUnit.SECONDS);
        barrier2.await(10L, TimeUnit.SECONDS);
        barrier2.await(10L, TimeUnit.SECONDS);
        sentRetry.receiveAll();
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        this.assertTopologyId(currentTopologyId + 2, this.cache(0));
        topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        if (retryTopologyOnNode2 < 3) {
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.NO_REBALANCE, topologyManager0, topologyManager1, joiner.topologyManager);
        joiner.joinerFuture.get();
    }

    public void testScenario_323() throws Exception {
        this.testScenario_xyx(3, 2);
    }

    public void testScenario_333() throws Exception {
        this.testScenario_xyx(3, 3);
    }

    public void testScenario_434() throws Exception {
        this.testScenario_xyx(4, 3);
    }

    protected void testScenario_xyx(int topologyOnNode0, int topologyOnNode2) throws Exception {
        AssertJUnit.assertTrue((3 <= topologyOnNode0 && topologyOnNode0 <= 4 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((2 <= topologyOnNode2 && topologyOnNode2 <= 3 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((topologyOnNode0 - topologyOnNode2 <= 1 ? 1 : 0) != 0);
        this.assertClusterSize("Wrong cluster size.", 2);
        String key = String.format("key_%d%d%d", topologyOnNode0, topologyOnNode2, topologyOnNode2);
        this.ownerCheckAndInit(this.cache(1), key, "v");
        BlockingLocalTopologyManager topologyManager0 = this.replaceTopologyManager(this.manager(0));
        BlockingLocalTopologyManager topologyManager1 = this.replaceTopologyManager(this.manager(1));
        int currentTopologyId = this.currentTopologyId(this.cache(0));
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new AssertNoRetryInterceptor(), StateTransferInterceptor.class);
        FailReadsInterceptor fri = new FailReadsInterceptor();
        this.cache(1).getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)fri, 0);
        NewNode joiner = this.addNode(cb -> cb.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.FIRST).interceptor((AsyncInterceptor)new WaitForTopologyInterceptor(currentTopologyId + topologyOnNode2)));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_ALL_WRITE_ALL, topologyManager0, topologyManager1, joiner.topologyManager);
        topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        if (topologyOnNode2 > 2) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode0 > 3) {
            topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.NO_REBALANCE);
        }
        this.awaitForTopology(currentTopologyId + topologyOnNode0, this.cache(0));
        Future<Object> remoteGetFuture = this.remoteGet(this.cache(0), key);
        AssertJUnit.assertEquals((String)"Wrong value from remote get.", (Object)"v", (Object)remoteGetFuture.get());
        fri.assertNotHit();
        this.assertTopologyId(currentTopologyId + topologyOnNode0, this.cache(0));
        if (topologyOnNode2 < 3) {
            topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
            joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        }
        if (topologyOnNode0 < 4) {
            topologyManager0.confirmTopologyUpdate(CacheTopology.Phase.NO_REBALANCE);
        }
        topologyManager1.confirmTopologyUpdate(CacheTopology.Phase.NO_REBALANCE);
        joiner.topologyManager.confirmTopologyUpdate(CacheTopology.Phase.NO_REBALANCE);
        joiner.joinerFuture.get();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, RemoteGetDuringStateTransferSCI.INSTANCE, this.configuration());
    }

    @Override
    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager cm) {
        NoOpGlobalConfigurationManager.amendCacheManager(cm);
    }

    private Future<Object> remoteGet(Cache cache, Object key) {
        return this.fork(() -> cache.get(key));
    }

    private int currentTopologyId(Cache cache) {
        return cache.getAdvancedCache().getDistributionManager().getCacheTopology().getTopologyId();
    }

    private void assertTopologyId(int expectedTopologyId, Cache cache) {
        AssertJUnit.assertEquals((int)expectedTopologyId, (int)this.currentTopologyId(cache));
    }

    private void awaitForTopology(int expectedTopologyId, Cache cache) {
        this.eventuallyEquals(expectedTopologyId, () -> this.currentTopologyId(cache));
    }

    private void awaitUntilNotInDataContainer(Cache cache, Object key) {
        this.eventually(() -> !cache.getAdvancedCache().getDataContainer().containsKey(key));
    }

    private NewNode addNode(Consumer<ConfigurationBuilder> modifyConfiguration) {
        NewNode newNode = new NewNode();
        ConfigurationBuilder configurationBuilder = this.configuration();
        if (modifyConfiguration != null) {
            modifyConfiguration.accept(configurationBuilder);
        }
        EmbeddedCacheManager embeddedCacheManager = this.addClusterEnabledCacheManager(RemoteGetDuringStateTransferSCI.INSTANCE, configurationBuilder);
        newNode.topologyManager = this.replaceTopologyManager(embeddedCacheManager);
        newNode.joinerFuture = this.fork(() -> {
            this.waitForClusterToForm();
            return null;
        });
        return newNode;
    }

    private void ownerCheckAndInit(Cache<Object, Object> owner, Object key, Object value) {
        AssertJUnit.assertTrue((String)(this.address(owner) + " should be the owner of " + key + "."), (boolean)DistributionTestHelper.isFirstOwner(owner, key));
        owner.put(key, value);
        this.assertCacheValue(key, value);
    }

    private void assertCacheValue(Object key, Object value) {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((String)("Wrong value for key " + key + " on " + this.address(cache) + "."), (Object)value, (Object)cache.get(key));
        }
    }

    private ConfigurationBuilder configuration() {
        ConfigurationBuilder builder = RemoteGetDuringStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().numSegments(1).numOwners(1).consistentHashFactory((ConsistentHashFactory)new SingleKeyConsistentHashFactory()).stateTransfer().timeout(30L, TimeUnit.SECONDS);
        return builder;
    }

    private BlockingLocalTopologyManager replaceTopologyManager(EmbeddedCacheManager cacheContainer) {
        BlockingLocalTopologyManager localTopologyManager = BlockingLocalTopologyManager.replaceTopologyManagerDefaultCache(cacheContainer);
        this.topologyManagerList.add(localTopologyManager);
        return localTopologyManager;
    }

    private ControlledRpcManager replaceRpcManager(Cache cache) {
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(cache);
        this.rpcManagerList.add(controlledRpcManager);
        return controlledRpcManager;
    }

    @AutoProtoSchemaBuilder(includeClasses={SingleKeyConsistentHashFactory.class}, schemaFileName="test.core.RemoteGetDuringStateTransferTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.RemoteGetDuringStateTransferTest", service=false)
    static interface RemoteGetDuringStateTransferSCI
    extends SerializationContextInitializer {
        public static final RemoteGetDuringStateTransferSCI INSTANCE = new RemoteGetDuringStateTransferSCIImpl();
    }

    private class NewNode {
        Future<Void> joinerFuture;
        BlockingLocalTopologyManager topologyManager;

        private NewNode() {
        }
    }

    static class AssertNoRetryInterceptor
    extends DDAsyncInterceptor {
        AssertNoRetryInterceptor() {
        }

        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) {
            AssertJUnit.assertFalse((boolean)command.hasAnyFlag(FlagBitSets.COMMAND_RETRY));
            return this.invokeNextAndExceptionally(ctx, (VisitableCommand)command, (rCtx, rCommand, t) -> {
                AssertJUnit.assertFalse((boolean)(t instanceof OutdatedTopologyException));
                throw t;
            });
        }
    }

    static class FailReadsInterceptor
    extends BaseCustomAsyncInterceptor {
        private final AtomicBoolean hit = new AtomicBoolean();

        FailReadsInterceptor() {
        }

        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
            this.hit.set(true);
            throw new IllegalStateException("Did not expect the command to be executed on node " + this.cache.getCacheManager().getAddress());
        }

        public void assertNotHit() {
            AssertJUnit.assertFalse((boolean)this.hit.get());
        }
    }

    static class WaitForTopologyInterceptor
    extends DDAsyncInterceptor {
        private static final Log log = LogFactory.getLog(RemoteGetDuringStateTransferTest.class);
        protected final int expectedTopologyId;
        private volatile DistributionManager distributionManager;
        private volatile StateTransferLock stateTransferLock;

        private WaitForTopologyInterceptor(int expectedTopologyId) {
            this.expectedTopologyId = expectedTopologyId;
        }

        @Inject
        public void init(DistributionManager distributionManager, StateTransferLock stateTransferLock) {
            this.distributionManager = distributionManager;
            this.stateTransferLock = stateTransferLock;
        }

        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
            AssertJUnit.assertNotNull((Object)this.stateTransferLock);
            log.tracef("Waiting for topology %d before executing %s", this.expectedTopologyId, (Object)command);
            this.stateTransferLock.topologyFuture(this.expectedTopologyId).toCompletableFuture().get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((int)this.expectedTopologyId, (int)this.distributionManager.getCacheTopology().getTopologyId());
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
    }

    @ProtoName(value="RemoteGetSingleKeyConsistentHashFactory")
    public static class SingleKeyConsistentHashFactory
    extends BaseControlledConsistentHashFactory.Default {
        SingleKeyConsistentHashFactory() {
            super(1);
        }

        @Override
        protected int[][] assignOwners(int numSegments, List<Address> members) {
            return new int[][]{{members.size() - 1}};
        }
    }
}

