/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.annotations.Test;

@Test(testName="statetransfer.StaleLocksWithCommitDuringStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class StaleLocksWithCommitDuringStateTransferTest
extends MultipleCacheManagersTest {
    Cache<MagicKey, String> c1;
    Cache<MagicKey, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).remoteTimeout(5000L).transaction().transactionMode(TransactionMode.TRANSACTIONAL).cacheStopTimeout(100L);
        this.createCluster(TestDataSCI.INSTANCE, cb, 2);
        this.c1 = this.cache(0);
        this.c2 = this.cache(1);
        this.waitForClusterToForm();
    }

    public void testRollbackLocalFailure() throws Exception {
        this.doStateTransferInProgressTest(false, true);
    }

    public void testCommitLocalFailure() throws Exception {
        this.doStateTransferInProgressTest(true, true);
    }

    public void testRollbackRemoteFailure() throws Exception {
        this.doStateTransferInProgressTest(false, false);
    }

    public void testCommitRemoteFailure() throws Exception {
        this.doStateTransferInProgressTest(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStateTransferInProgressTest(boolean commit, final boolean failOnOriginator) throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.tm(this.c1).begin();
        this.c1.put((Object)k1, (Object)"v1");
        this.c1.put((Object)k2, (Object)"v2");
        TransactionTable txTable = TestingUtil.extractComponent(this.c1, TransactionTable.class);
        TransactionCoordinator txCoordinator = TestingUtil.extractComponent(this.c1, TransactionCoordinator.class);
        LocalTransaction localTx = txTable.getLocalTransaction(this.tm(this.c1).getTransaction());
        CompletionStages.join((CompletionStage)txCoordinator.prepare(localTx));
        final CountDownLatch commitLatch = new CountDownLatch(1);
        Thread worker = new Thread("RehasherSim,StaleLocksWithCommitDuringStateTransferTest"){

            @Override
            public void run() {
                try {
                    StateTransferLock blockFirst = TestingUtil.extractComponent(failOnOriginator ? StaleLocksWithCommitDuringStateTransferTest.this.c1 : StaleLocksWithCommitDuringStateTransferTest.this.c2, StateTransferLock.class);
                    StateTransferLock blockSecond = TestingUtil.extractComponent(failOnOriginator ? StaleLocksWithCommitDuringStateTransferTest.this.c2 : StaleLocksWithCommitDuringStateTransferTest.this.c1, StateTransferLock.class);
                    try {
                        blockFirst.acquireExclusiveTopologyLock();
                        blockSecond.acquireExclusiveTopologyLock();
                        commitLatch.countDown();
                        Thread.sleep(1000L);
                    }
                    finally {
                        blockSecond.releaseExclusiveTopologyLock();
                        blockFirst.releaseExclusiveTopologyLock();
                    }
                }
                catch (Throwable t) {
                    log.errorf(t, "Error blocking/unblocking transactions", new Object[0]);
                }
            }
        };
        worker.start();
        commitLatch.await(10L, TimeUnit.SECONDS);
        try {
            if (commit) {
                this.tm(this.c1).commit();
            } else {
                this.tm(this.c1).rollback();
            }
            this.tm(this.c1).suspend();
        }
        finally {
            worker.join();
        }
        this.assertEventuallyNotLocked(this.c1, k1);
        this.assertEventuallyNotLocked(this.c2, k1);
        this.assertEventuallyNotLocked(this.c1, k2);
        this.assertEventuallyNotLocked(this.c2, k2);
    }

    public void testRollbackSuspectFailure() throws Exception {
        this.doTestSuspect(false);
    }

    public void testCommitSuspectFailure() throws Exception {
        this.doTestSuspect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSuspect(boolean commit) throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.tm(this.c1).begin();
        this.c1.put((Object)k1, (Object)"v1");
        this.c1.put((Object)k2, (Object)"v2");
        TransactionTable txTable = TestingUtil.extractComponent(this.c1, TransactionTable.class);
        TransactionCoordinator txCoordinator = TestingUtil.extractComponent(this.c1, TransactionCoordinator.class);
        LocalTransaction localTx = txTable.getLocalTransaction(this.tm(this.c1).getTransaction());
        CompletionStages.join((CompletionStage)txCoordinator.prepare(localTx));
        AsyncInterceptorChain c2ic = this.c2.getAdvancedCache().getAsyncInterceptorChain();
        c2ic.addInterceptorBefore((AsyncInterceptor)new DelayCommandInterceptor(), StateTransferInterceptor.class);
        Thread worker = new Thread("RehasherSim,StaleLocksWithCommitDuringStateTransferTest"){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    StaleLocksWithCommitDuringStateTransferTest.this.manager(StaleLocksWithCommitDuringStateTransferTest.this.c2).stop();
                }
                catch (InterruptedException e) {
                    log.errorf((Throwable)e, "Error stopping cache", new Object[0]);
                }
            }
        };
        worker.start();
        try {
            if (commit) {
                CompletionStages.join((CompletionStage)txCoordinator.commit(localTx, false));
            } else {
                CompletionStages.join((CompletionStage)txCoordinator.rollback(localTx));
            }
            this.tm(this.c1).suspend();
        }
        finally {
            worker.join();
        }
        this.assertEventuallyNotLocked(this.c1, k1);
        this.assertEventuallyNotLocked(this.c1, k2);
    }

    static class DelayCommandInterceptor
    extends BaseAsyncInterceptor {
        DelayCommandInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (command instanceof CommitCommand) {
                Thread.sleep(3000L);
            }
            return this.invokeNext(ctx, command);
        }
    }
}

